/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients.cmdClient;

import io.skodjob.testframe.clients.cmdClient.BaseCmdKubeClient;
import io.skodjob.testframe.executor.Exec;
import java.util.List;
import java.util.Map;

public class Oc
extends BaseCmdKubeClient<Oc> {
    private static final String OC = "oc";

    public Oc() {
        this(null);
    }

    public Oc(String config) {
        super(config);
    }

    private Oc(String futureNamespace, String config) {
        super(config);
        this.namespace = futureNamespace;
    }

    @Override
    public String defaultOlmNamespace() {
        return "openshift-marketplace";
    }

    public Oc inNamespace(String namespace) {
        return new Oc(namespace, this.config);
    }

    @Override
    public String getCurrentNamespace() {
        return this.namespace;
    }

    @Override
    public Oc createNamespace(String name) {
        try (BaseCmdKubeClient.Context context = this.defaultContext();){
            Exec.exec(this.cmd(), "new-project", name);
        }
        return this;
    }

    public Oc newApp(String template, Map<String, String> params) {
        List<String> cmd = this.command("new-app", template);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            cmd.add("-p");
            cmd.add(entry.getKey() + "=" + entry.getValue());
        }
        Exec.exec(cmd);
        return this;
    }

    @Override
    public String cmd() {
        return OC;
    }

    @Override
    public String getUsername() {
        return Exec.exec(this.cmd(), "whoami").out();
    }
}

