/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * The composite future wraps a list of {@link io.vertx.axle.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 * The handlers set for the coordinated futures are overridden by the handler of the composite future.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.CompositeFuture.class)
public class CompositeFuture extends io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CompositeFuture that = (CompositeFuture) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<CompositeFuture> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new CompositeFuture((io.vertx.core.CompositeFuture) obj),
    CompositeFuture::getDelegate
  );

  private final io.vertx.core.CompositeFuture delegate;
  
  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  CompositeFuture() {    super(null);
    this.delegate = null;
  }

  public io.vertx.core.CompositeFuture getDelegate() {
    return delegate;
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   */
  @Deprecated()
  public void complete(io.vertx.axle.core.CompositeFuture result) { 
    delegate.complete(result.getDelegate());
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   * @return false when the future is already completed
   */
  @Deprecated()
  public boolean tryComplete(io.vertx.axle.core.CompositeFuture result) { 
    boolean ret = delegate.tryComplete(result.getDelegate());
    return ret;
  }

  /**
   * The result of the operation. This will be null if the operation failed.
   * @return the result or null if the operation failed.
   */
  public io.vertx.axle.core.CompositeFuture result() { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(delegate.result());
    return ret;
  }

  /**
   * Alias for {@link io.vertx.axle.core.Future#compose}.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.axle.core.Future<U> flatMap(Function<io.vertx.axle.core.CompositeFuture, io.vertx.axle.core.Future<U>> mapper) { 
    io.vertx.axle.core.Future<U> ret = io.vertx.axle.core.Future.newInstance(delegate.flatMap(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.axle.core.Future<U> ret = mapper.apply(io.vertx.axle.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>mapper</code> function.<p>
   * <p>
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   * <p>
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   * <p>
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> io.vertx.axle.core.Future<U> compose(Function<io.vertx.axle.core.CompositeFuture, io.vertx.axle.core.Future<U>> mapper) { 
    io.vertx.axle.core.Future<U> ret = io.vertx.axle.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.axle.core.Future<U> ret = mapper.apply(io.vertx.axle.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>successMapper</code> and <code>failureMapper</code> functions.<p>
   * <p>
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>successMapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   * <p>
   * When this future (the one on which <code>compose</code> is called) fails, the <code>failureMapper</code> will be called with
   * the failure and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   * <p>
   * If any mapper function throws an exception, the returned future will be failed with this exception.<p>
   * @param successMapper the function mapping the success
   * @param failureMapper the function mapping the failure
   * @return the composed future
   */
  public <U> io.vertx.axle.core.Future<U> compose(Function<io.vertx.axle.core.CompositeFuture, io.vertx.axle.core.Future<U>> successMapper, Function<Throwable, io.vertx.axle.core.Future<U>> failureMapper) { 
    io.vertx.axle.core.Future<U> ret = io.vertx.axle.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.axle.core.Future<U> ret = successMapper.apply(io.vertx.axle.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }, new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(java.lang.Throwable arg) {
        io.vertx.axle.core.Future<U> ret = failureMapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   * <p>
   * When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   * <p>
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   * <p>
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> io.vertx.axle.core.Future<U> map(Function<io.vertx.axle.core.CompositeFuture, U> mapper) { 
    io.vertx.axle.core.Future<U> ret = io.vertx.axle.core.Future.newInstance(delegate.map(new java.util.function.Function<io.vertx.core.CompositeFuture,U>() {
      public U apply(io.vertx.core.CompositeFuture arg) {
        U ret = mapper.apply(io.vertx.axle.core.CompositeFuture.newInstance(arg));
        return ret;
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  @Deprecated()
  public Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>> ret = new Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.axle.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * Handles a failure of this Future by returning the result of another Future.
   * If the mapper fails, then the returned future will be failed with this failure.
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> recover(Function<Throwable, io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture>> mapper) { 
    io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> ret = io.vertx.axle.core.Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<io.vertx.core.CompositeFuture>>() {
      public io.vertx.core.Future<io.vertx.core.CompositeFuture> apply(java.lang.Throwable arg) {
        io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_0);
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   * <p>
   * When this future fails, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   * <p>
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   * <p>
   * When this future succeeds, the result will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> otherwise(Function<Throwable, io.vertx.axle.core.CompositeFuture> mapper) { 
    io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> ret = io.vertx.axle.core.Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,io.vertx.core.CompositeFuture>() {
      public io.vertx.core.CompositeFuture apply(java.lang.Throwable arg) {
        io.vertx.axle.core.CompositeFuture ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), TYPE_ARG_1);
    return ret;
  }

  /**
   * Map the failure of a future to a specific <code>value</code>.<p>
   * <p>
   * When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
   * <p>
   * When this future succeeds, the result will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> otherwise(io.vertx.axle.core.CompositeFuture value) { 
    io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> ret = io.vertx.axle.core.Future.newInstance(delegate.otherwise(value.getDelegate()), TYPE_ARG_2);
    return ret;
  }

  /**
   * Map the failure of a future to <code>null</code>.<p>
   * <p>
   * This is a convenience for <code>future.otherwise((T) null)</code>.<p>
   * <p>
   * When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
   * <p>
   * When this future succeeds, the result will be propagated to the returned future.
   * @return the mapped future
   */
  public io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> otherwiseEmpty() { 
    io.vertx.axle.core.Future<io.vertx.axle.core.CompositeFuture> ret = io.vertx.axle.core.Future.newInstance(delegate.otherwiseEmpty(), TYPE_ARG_3);
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * The returned future fails as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.axle.core.CompositeFuture all(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#all} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.axle.core.CompositeFuture all(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#all} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.axle.core.CompositeFuture all(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#all} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.axle.core.CompositeFuture all(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#all} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.axle.core.CompositeFuture all(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5, io.vertx.axle.core.Future<T6> f6) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#all} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.axle.core.CompositeFuture all(List<io.vertx.axle.core.Future> futures) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when any futures is succeeded, failed when all futures are failed.
   * <p/>
   * The returned future succeeds as soon as one of <code>f1</code> or <code>f2</code> succeeds.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.axle.core.CompositeFuture any(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#any} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.axle.core.CompositeFuture any(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#any} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.axle.core.CompositeFuture any(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#any} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.axle.core.CompositeFuture any(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#any} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.axle.core.CompositeFuture any(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5, io.vertx.axle.core.Future<T6> f6) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#any} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.axle.core.CompositeFuture any(List<io.vertx.axle.core.Future> futures) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * It always wait until all its futures are completed and will not fail as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.axle.core.CompositeFuture join(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#join} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.axle.core.CompositeFuture join(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#join} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.axle.core.CompositeFuture join(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#join} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.axle.core.CompositeFuture join(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#join} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.axle.core.CompositeFuture join(io.vertx.axle.core.Future<T1> f1, io.vertx.axle.core.Future<T2> f2, io.vertx.axle.core.Future<T3> f3, io.vertx.axle.core.Future<T4> f4, io.vertx.axle.core.Future<T5> f5, io.vertx.axle.core.Future<T6> f6) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.CompositeFuture#join} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.axle.core.CompositeFuture join(List<io.vertx.axle.core.Future> futures) { 
    io.vertx.axle.core.CompositeFuture ret = io.vertx.axle.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  @Deprecated()
  private io.vertx.axle.core.CompositeFuture __setHandler(Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  @Deprecated()
  public CompletionStage<io.vertx.axle.core.CompositeFuture> setHandler() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __setHandler(handler);
    });
  }

  private io.vertx.axle.core.CompositeFuture __onComplete(Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>> handler) { 
    delegate.onComplete(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public CompletionStage<io.vertx.axle.core.CompositeFuture> onComplete() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __onComplete(handler);
    });
  }

  private io.vertx.axle.core.CompositeFuture __onSuccess(Handler<io.vertx.axle.core.CompositeFuture> handler) { 
    delegate.onSuccess(new Handler<io.vertx.core.CompositeFuture>() {
      public void handle(io.vertx.core.CompositeFuture event) {
        handler.handle(io.vertx.axle.core.CompositeFuture.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.CompositeFuture onSuccess(Consumer<io.vertx.axle.core.CompositeFuture> handler) {
    return __onSuccess(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.CompositeFuture __onFailure(Handler<Throwable> handler) { 
    delegate.onFailure(handler);
    return this;
  }

  public io.vertx.axle.core.CompositeFuture onFailure(Consumer<Throwable> handler) {
    return __onFailure(handler != null ? handler::accept : null);
  }

  /**
   * Set this instance as result. Any handler will be called, if there is one, and the future will be marked as completed.
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Try to set this instance as result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Returns a cause of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = delegate.cause(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is succeeded
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = delegate.succeeded(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is failed
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = delegate.failed(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is completed
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = delegate.isComplete(index);
    return ret;
  }

  /**
   * Returns the result of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public <T> T resultAt(int index) { 
    T ret = (T) delegate.resultAt(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture>(o1 -> io.vertx.axle.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture> TYPE_ARG_1 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture>(o1 -> io.vertx.axle.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture> TYPE_ARG_2 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture>(o1 -> io.vertx.axle.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture> TYPE_ARG_3 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.CompositeFuture>(o1 -> io.vertx.axle.core.CompositeFuture.newInstance((io.vertx.core.CompositeFuture)o1), o1 -> o1.getDelegate());
  private Handler<AsyncResult<io.vertx.axle.core.CompositeFuture>> cached_0;

  public static  CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }
}
