/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.dns.DnsClientOptions;
import java.util.function.Supplier;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.VertxOptions;
import java.util.Set;
import io.vertx.core.Verticle;
import io.vertx.core.net.NetClientOptions;
import java.util.concurrent.TimeUnit;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.Handler;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.axle.core.Vertx#vertx},
 * {@link io.vertx.axle.core.Vertx#vertx} and {@link io.vertx.axle.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.Vertx.class)
public class Vertx implements io.vertx.axle.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Vertx that = (Vertx) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<Vertx> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new Vertx((io.vertx.core.Vertx) obj),
    Vertx::getDelegate
  );

  private final io.vertx.core.Vertx delegate;
  
  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Vertx() {    this.delegate = null;
  }

  public io.vertx.core.Vertx getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Creates a non clustered instance using default options.
   * @return the instance
   */
  public static io.vertx.axle.core.Vertx vertx() { 
    io.vertx.axle.core.Vertx ret = io.vertx.axle.core.Vertx.newInstance(io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * Creates a non clustered instance using the specified options
   * @param options the options to use
   * @return the instance
   */
  public static io.vertx.axle.core.Vertx vertx(VertxOptions options) { 
    io.vertx.axle.core.Vertx ret = io.vertx.axle.core.Vertx.newInstance(io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @param resultHandler the result handler that will receive the result
   */
  private static void __clusteredVertx(VertxOptions options, Handler<AsyncResult<io.vertx.axle.core.Vertx>> resultHandler) { 
    io.vertx.core.Vertx.clusteredVertx(options, new Handler<AsyncResult<io.vertx.core.Vertx>>() {
      public void handle(AsyncResult<io.vertx.core.Vertx> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.Vertx.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   */
  public static CompletionStage<io.vertx.axle.core.Vertx> clusteredVertx(VertxOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __clusteredVertx(options, handler);
    });
  }

  /**
   * Gets the current context
   * @return The current context or null if no current context
   */
  public static io.vertx.axle.core.Context currentContext() { 
    io.vertx.axle.core.Context ret = io.vertx.axle.core.Context.newInstance(io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * Gets the current context, or creates one if there isn't one
   * @return The current context (created if didn't exist)
   */
  public io.vertx.axle.core.Context getOrCreateContext() { 
    io.vertx.axle.core.Context ret = io.vertx.axle.core.Context.newInstance(delegate.getOrCreateContext());
    return ret;
  }

  /**
   * Create a TCP/SSL server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.axle.core.net.NetServer createNetServer(NetServerOptions options) { 
    io.vertx.axle.core.net.NetServer ret = io.vertx.axle.core.net.NetServer.newInstance(delegate.createNetServer(options));
    return ret;
  }

  /**
   * Create a TCP/SSL server using default options
   * @return the server
   */
  public io.vertx.axle.core.net.NetServer createNetServer() { 
    io.vertx.axle.core.net.NetServer ret = io.vertx.axle.core.net.NetServer.newInstance(delegate.createNetServer());
    return ret;
  }

  /**
   * Create a TCP/SSL client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.axle.core.net.NetClient createNetClient(NetClientOptions options) { 
    io.vertx.axle.core.net.NetClient ret = io.vertx.axle.core.net.NetClient.newInstance(delegate.createNetClient(options));
    return ret;
  }

  /**
   * Create a TCP/SSL client using default options
   * @return the client
   */
  public io.vertx.axle.core.net.NetClient createNetClient() { 
    io.vertx.axle.core.net.NetClient ret = io.vertx.axle.core.net.NetClient.newInstance(delegate.createNetClient());
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.axle.core.http.HttpServer createHttpServer(HttpServerOptions options) { 
    io.vertx.axle.core.http.HttpServer ret = io.vertx.axle.core.http.HttpServer.newInstance(delegate.createHttpServer(options));
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using default options
   * @return the server
   */
  public io.vertx.axle.core.http.HttpServer createHttpServer() { 
    io.vertx.axle.core.http.HttpServer ret = io.vertx.axle.core.http.HttpServer.newInstance(delegate.createHttpServer());
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.axle.core.http.HttpClient createHttpClient(HttpClientOptions options) { 
    io.vertx.axle.core.http.HttpClient ret = io.vertx.axle.core.http.HttpClient.newInstance(delegate.createHttpClient(options));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using default options
   * @return the client
   */
  public io.vertx.axle.core.http.HttpClient createHttpClient() { 
    io.vertx.axle.core.http.HttpClient ret = io.vertx.axle.core.http.HttpClient.newInstance(delegate.createHttpClient());
    return ret;
  }

  /**
   * Create a datagram socket using the specified options
   * @param options the options to use
   * @return the socket
   */
  public io.vertx.axle.core.datagram.DatagramSocket createDatagramSocket(DatagramSocketOptions options) { 
    io.vertx.axle.core.datagram.DatagramSocket ret = io.vertx.axle.core.datagram.DatagramSocket.newInstance(delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * Create a datagram socket using default options
   * @return the socket
   */
  public io.vertx.axle.core.datagram.DatagramSocket createDatagramSocket() { 
    io.vertx.axle.core.datagram.DatagramSocket ret = io.vertx.axle.core.datagram.DatagramSocket.newInstance(delegate.createDatagramSocket());
    return ret;
  }

  /**
   * Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
   * @return the filesystem object
   */
  public io.vertx.axle.core.file.FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.file.FileSystem ret = io.vertx.axle.core.file.FileSystem.newInstance(delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the event bus object. There is a single instance of EventBus per Vertx instance.
   * @return the event bus object
   */
  public io.vertx.axle.core.eventbus.EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.eventbus.EventBus ret = io.vertx.axle.core.eventbus.EventBus.newInstance(delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server at the specified host and port, with the default query timeout (5 seconds)
   * <p/>
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public io.vertx.axle.core.dns.DnsClient createDnsClient(int port, String host) { 
    io.vertx.axle.core.dns.DnsClient ret = io.vertx.axle.core.dns.DnsClient.newInstance(delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * Create a DNS client to connect to the DNS server configured by {@link io.vertx.core.VertxOptions}
   * <p>
   * DNS client takes the first configured resolver address provided by }
   * @return the DNS client
   */
  public io.vertx.axle.core.dns.DnsClient createDnsClient() { 
    io.vertx.axle.core.dns.DnsClient ret = io.vertx.axle.core.dns.DnsClient.newInstance(delegate.createDnsClient());
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server
   * @param options the client options
   * @return the DNS client
   */
  public io.vertx.axle.core.dns.DnsClient createDnsClient(DnsClientOptions options) { 
    io.vertx.axle.core.dns.DnsClient ret = io.vertx.axle.core.dns.DnsClient.newInstance(delegate.createDnsClient(options));
    return ret;
  }

  /**
   * Get the shared data object. There is a single instance of SharedData per Vertx instance.
   * @return the shared data object
   */
  public io.vertx.axle.core.shareddata.SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.axle.core.shareddata.SharedData ret = io.vertx.axle.core.shareddata.SharedData.newInstance(delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  private long __setTimer(long delay, Handler<Long> handler) { 
    long ret = delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, Consumer<Long> handler) {
    return __setTimer(delay, handler != null ? handler::accept : null);
  }

  /**
   * Returns a one-shot timer as a read stream. The timer will be fired after <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the timer stream
   */
  public io.vertx.axle.core.TimeoutStream timerStream(long delay) { 
    io.vertx.axle.core.TimeoutStream ret = io.vertx.axle.core.TimeoutStream.newInstance(delegate.timerStream(delay));
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  private long __setPeriodic(long delay, Handler<Long> handler) { 
    long ret = delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, Consumer<Long> handler) {
    return __setPeriodic(delay, handler != null ? handler::accept : null);
  }

  /**
   * Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public io.vertx.axle.core.TimeoutStream periodicStream(long delay) { 
    io.vertx.axle.core.TimeoutStream ret = io.vertx.axle.core.TimeoutStream.newInstance(delegate.periodicStream(delay));
    return ret;
  }

  /**
   * Cancels the timer with the specified <code>id</code>.
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = delegate.cancelTimer(id);
    return ret;
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  private void __runOnContext(Handler<Void> action) { 
    delegate.runOnContext(action);
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(Consumer<Void> action) {
    __runOnContext(action != null ? action::accept : null);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @param completionHandler The handler will be notified when the close is complete.
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   */
  public CompletionStage<String> deployVerticle(String name) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __deployVerticle(name, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   */
  public CompletionStage<String> deployVerticle(String name, DeploymentOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __deployVerticle(name, options, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @param completionHandler a handler which will be notified when the undeployment is complete
   */
  private void __undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.undeploy(deploymentID, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   */
  public CompletionStage<Void> undeploy(String deploymentID) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __undeploy(deploymentID, handler);
    });
  }

  /**
   * Return a Set of deployment IDs for the currently deployed deploymentIDs.
   * @return Set of deployment IDs
   */
  public Set<String> deploymentIDs() { 
    Set<String> ret = delegate.deploymentIDs();
    return ret;
  }

  /**
   * Is this Vert.x instance clustered?
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = delegate.isClustered();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.axle.core.Promise#complete} or {@link io.vertx.axle.core.Promise#complete} method, or the {@link io.vertx.axle.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.axle.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  private <T> void __executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.axle.core.Promise.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }, ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.axle.core.Promise#complete} or {@link io.vertx.axle.core.Promise#complete} method, or the {@link io.vertx.axle.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.axle.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> CompletionStage<T> executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __executeBlocking(blockingCodeHandler, ordered, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  private <T> void __executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.axle.core.Promise.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }, resultHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> CompletionStage<T> executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __executeBlocking(blockingCodeHandler, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>poolSize</code>.
   * @param name 
   * @return 
   */
  public io.vertx.axle.core.WorkerExecutor createSharedWorkerExecutor(String name) { 
    io.vertx.axle.core.WorkerExecutor ret = io.vertx.axle.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTime</code>.
   * @param name 
   * @param poolSize 
   * @return 
   */
  public io.vertx.axle.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) { 
    io.vertx.axle.core.WorkerExecutor ret = io.vertx.axle.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize));
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#createSharedWorkerExecutor} but with the .
   * @param name 
   * @param poolSize 
   * @param maxExecuteTime 
   * @return 
   */
  public io.vertx.axle.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) { 
    io.vertx.axle.core.WorkerExecutor ret = io.vertx.axle.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
    return ret;
  }

  /**
   * Create a named worker executor, the executor should be closed when it's not needed anymore to release
   * resources.<p/>
   *
   * This method can be called mutiple times with the same <code>name</code>. Executors with the same name will share
   * the same worker pool. The worker pool size , max execute time and unit of max execute time are set when the worker pool is created and
   * won't change after.<p>
   *
   * The worker pool is released when all the {@link io.vertx.axle.core.WorkerExecutor} sharing the same name are closed.
   * @param name the name of the worker executor
   * @param poolSize the size of the pool
   * @param maxExecuteTime the value of max worker execute time
   * @param maxExecuteTimeUnit the value of unit of max worker execute time
   * @return the named worker executor
   */
  public io.vertx.axle.core.WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) { 
    io.vertx.axle.core.WorkerExecutor ret = io.vertx.axle.core.WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
    return ret;
  }

  /**
   * @return whether the native transport is used
   */
  public boolean isNativeTransportEnabled() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isNativeTransportEnabled();
    cached_3 = ret;
    return ret;
  }

  /**
   * Set a default exception handler for {@link io.vertx.axle.core.Context}, set on  at creation.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.Vertx __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a default exception handler for {@link io.vertx.axle.core.Context}, set on  at creation.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.Vertx exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticle, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy
   * @return 
   */
  public CompletionStage<String> deployVerticle(Verticle verticle) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __deployVerticle(verticle, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  private void __deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticle, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return 
   */
  public CompletionStage<String> deployVerticle(Verticle verticle, DeploymentOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __deployVerticle(verticle, options, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.Verticle} instance is created by
   * invoking the <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param verticleSupplier 
   * @param options 
   * @param completionHandler 
   */
  private void __deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(verticleSupplier, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.Vertx#deployVerticle} but {@link io.vertx.core.Verticle} instance is created by
   * invoking the <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param verticleSupplier 
   * @param options 
   * @return 
   */
  public CompletionStage<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __deployVerticle(verticleSupplier, options, handler);
    });
  }

  /**
   * Register a <code>VerticleFactory</code> that can be used for deploying Verticles based on an identifier.
   * @param factory the factory to register
   */
  public void registerVerticleFactory(VerticleFactory factory) { 
    delegate.registerVerticleFactory(factory);
  }

  /**
   * Unregister a <code>VerticleFactory</code>
   * @param factory the factory to unregister
   */
  public void unregisterVerticleFactory(VerticleFactory factory) { 
    delegate.unregisterVerticleFactory(factory);
  }

  /**
   * Return the Set of currently registered verticle factories.
   * @return the set of verticle factories
   */
  public Set<VerticleFactory> verticleFactories() { 
    Set<VerticleFactory> ret = delegate.verticleFactories();
    return ret;
  }

  /**
   * Return the Netty EventLoopGroup used by Vert.x
   * @return the EventLoopGroup
   */
  public EventLoopGroup nettyEventLoopGroup() { 
    EventLoopGroup ret = delegate.nettyEventLoopGroup();
    return ret;
  }

  private io.vertx.axle.core.file.FileSystem cached_0;
  private io.vertx.axle.core.eventbus.EventBus cached_1;
  private io.vertx.axle.core.shareddata.SharedData cached_2;
  private java.lang.Boolean cached_3;

  public static  Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }
}
