/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.eventbus;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A Vert.x event-bus is a light-weight distributed messaging system which allows different parts of your application,
 * or different applications and services to communicate with each in a loosely coupled way.
 * <p>
 * An event-bus supports publish-subscribe messaging, point-to-point messaging and request-response messaging.
 * <p>
 * Message delivery is best-effort and messages can be lost if failure of all or part of the event bus occurs.
 * <p>
 * Please refer to the documentation for more information on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.EventBus original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.eventbus.EventBus.class)
public class EventBus implements io.vertx.axle.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBus that = (EventBus) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<EventBus> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new EventBus((io.vertx.core.eventbus.EventBus) obj),
    EventBus::getDelegate
  );

  private final io.vertx.core.eventbus.EventBus delegate;
  
  public EventBus(io.vertx.core.eventbus.EventBus delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  EventBus() {    this.delegate = null;
  }

  public io.vertx.core.eventbus.EventBus getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Like  but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  private <T> io.vertx.axle.core.eventbus.EventBus __send(String address, Object message, Handler<AsyncResult<io.vertx.axle.core.eventbus.Message<T>>> replyHandler) { 
    delegate.send(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.eventbus.Message.newInstance(ar.result(), io.vertx.lang.axle.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like  but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public <T> CompletionStage<io.vertx.axle.core.eventbus.Message<T>> send(String address, Object message) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(address, message, handler);
    });
  }

  /**
   * Like  but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  private <T> io.vertx.axle.core.eventbus.EventBus __send(String address, Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.axle.core.eventbus.Message<T>>> replyHandler) { 
    delegate.send(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.eventbus.Message.newInstance(ar.result(), io.vertx.lang.axle.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like  but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param address the address to send it to
   * @param message the message, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public <T> CompletionStage<io.vertx.axle.core.eventbus.Message<T>> send(String address, Object message, DeliveryOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(address, message, options, handler);
    });
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __request(String address, Object message, Handler<AsyncResult<io.vertx.axle.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.eventbus.Message.newInstance(ar.result(), io.vertx.lang.axle.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Sends a message and and specify a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * The message will be delivered to at most one of the handlers registered to the address.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public <T> CompletionStage<io.vertx.axle.core.eventbus.Message<T>> request(String address, Object message) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __request(address, message, handler);
    });
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __request(String address, Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.axle.core.eventbus.Message<T>>> replyHandler) { 
    delegate.request(address, message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<T>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<T>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.eventbus.Message.newInstance(ar.result(), io.vertx.lang.axle.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to send it to
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public <T> CompletionStage<io.vertx.axle.core.eventbus.Message<T>> request(String address, Object message, DeliveryOptions options) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __request(address, message, options, handler);
    });
  }

  /**
   * Publish a message.<p>
   * The message will be delivered to all handlers registered to the address.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.eventbus.EventBus publish(String address, Object message) { 
    delegate.publish(address, message);
    return this;
  }

  /**
   * Like  but specifying <code>options</code> that can be used to configure the delivery.
   * @param address the address to publish it to
   * @param message the message, may be <code>null</code>
   * @param options the delivery options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.eventbus.EventBus publish(String address, Object message, DeliveryOptions options) { 
    delegate.publish(address, message, options);
    return this;
  }

  /**
   * Create a message consumer against the specified address.
   * <p>
   * The returned consumer is not yet registered
   * at the address, registration will be effective when {@link io.vertx.axle.core.eventbus.MessageConsumer#handler}
   * is called.
   * @param address the address that it will register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.axle.core.eventbus.MessageConsumer<T> consumer(String address) { 
    io.vertx.axle.core.eventbus.MessageConsumer<T> ret = io.vertx.axle.core.eventbus.MessageConsumer.newInstance(delegate.consumer(address), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a consumer and register it against the specified address.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  private <T> io.vertx.axle.core.eventbus.MessageConsumer<T> __consumer(String address, Handler<io.vertx.axle.core.eventbus.Message<T>> handler) { 
    io.vertx.axle.core.eventbus.MessageConsumer<T> ret = io.vertx.axle.core.eventbus.MessageConsumer.newInstance(delegate.consumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.axle.core.eventbus.Message.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a consumer and register it against the specified address.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.axle.core.eventbus.MessageConsumer<T> consumer(String address, Consumer<io.vertx.axle.core.eventbus.Message<T>> handler) {
    return __consumer(address, handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address to register it at
   * @return the event bus message consumer
   */
  public <T> io.vertx.axle.core.eventbus.MessageConsumer<T> localConsumer(String address) { 
    io.vertx.axle.core.eventbus.MessageConsumer<T> ret = io.vertx.axle.core.eventbus.MessageConsumer.newInstance(delegate.localConsumer(address), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  private <T> io.vertx.axle.core.eventbus.MessageConsumer<T> __localConsumer(String address, Handler<io.vertx.axle.core.eventbus.Message<T>> handler) { 
    io.vertx.axle.core.eventbus.MessageConsumer<T> ret = io.vertx.axle.core.eventbus.MessageConsumer.newInstance(delegate.localConsumer(address, new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.axle.core.eventbus.Message.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.EventBus#consumer} but the address won't be propagated across the cluster.
   * @param address the address that will register it at
   * @param handler the handler that will process the received messages
   * @return the event bus message consumer
   */
  public <T> io.vertx.axle.core.eventbus.MessageConsumer<T> localConsumer(String address, Consumer<io.vertx.axle.core.eventbus.Message<T>> handler) {
    return __localConsumer(address, handler != null ? handler::accept : null);
  }

  /**
   * Create a message sender against the specified address.
   * <p>
   * The returned sender will invoke the 
   * method when the stream {@link io.vertx.axle.core.streams.WriteStream#write} method is called with the sender
   * address and the provided data.
   * @param address the address to send it to
   * @return The sender
   */
  public <T> io.vertx.axle.core.eventbus.MessageProducer<T> sender(String address) { 
    io.vertx.axle.core.eventbus.MessageProducer<T> ret = io.vertx.axle.core.eventbus.MessageProducer.newInstance(delegate.sender(address), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.EventBus#sender} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to send it to
   * @param options the delivery options
   * @return The sender
   */
  public <T> io.vertx.axle.core.eventbus.MessageProducer<T> sender(String address, DeliveryOptions options) { 
    io.vertx.axle.core.eventbus.MessageProducer<T> ret = io.vertx.axle.core.eventbus.MessageProducer.newInstance(delegate.sender(address, options), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a message publisher against the specified address.
   * <p>
   * The returned publisher will invoke the 
   * method when the stream {@link io.vertx.axle.core.streams.WriteStream#write} method is called with the publisher
   * address and the provided data.
   * @param address The address to publish it to
   * @return The publisher
   */
  public <T> io.vertx.axle.core.eventbus.MessageProducer<T> publisher(String address) { 
    io.vertx.axle.core.eventbus.MessageProducer<T> ret = io.vertx.axle.core.eventbus.MessageProducer.newInstance(delegate.publisher(address), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.EventBus#publisher} but specifying delivery options that will be used for configuring the delivery of
   * the message.
   * @param address the address to publish it to
   * @param options the delivery options
   * @return The publisher
   */
  public <T> io.vertx.axle.core.eventbus.MessageProducer<T> publisher(String address, DeliveryOptions options) { 
    io.vertx.axle.core.eventbus.MessageProducer<T> ret = io.vertx.axle.core.eventbus.MessageProducer.newInstance(delegate.publisher(address, options), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Add an interceptor that will be called whenever a message is sent from Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __addOutboundInterceptor(Handler<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.axle.core.eventbus.DeliveryContext.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Add an interceptor that will be called whenever a message is sent from Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.axle.core.eventbus.EventBus addOutboundInterceptor(Consumer<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) {
    return __addOutboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.axle.core.eventbus.EventBus#addOutboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __removeOutboundInterceptor(Handler<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeOutboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.axle.core.eventbus.DeliveryContext.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.axle.core.eventbus.EventBus#addOutboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.axle.core.eventbus.EventBus removeOutboundInterceptor(Consumer<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) {
    return __removeOutboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * Add an interceptor that will be called whenever a message is received by Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __addInboundInterceptor(Handler<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.addInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.axle.core.eventbus.DeliveryContext.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Add an interceptor that will be called whenever a message is received by Vert.x
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.axle.core.eventbus.EventBus addInboundInterceptor(Consumer<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) {
    return __addInboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.axle.core.eventbus.EventBus#addInboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  private <T> io.vertx.axle.core.eventbus.EventBus __removeInboundInterceptor(Handler<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) { 
    delegate.removeInboundInterceptor(new Handler<io.vertx.core.eventbus.DeliveryContext<T>>() {
      public void handle(io.vertx.core.eventbus.DeliveryContext<T> event) {
        interceptor.handle(io.vertx.axle.core.eventbus.DeliveryContext.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    });
    return this;
  }

  /**
   * Remove an interceptor that was added by {@link io.vertx.axle.core.eventbus.EventBus#addInboundInterceptor}
   * @param interceptor the interceptor
   * @return a reference to this, so the API can be used fluently
   */
  public <T> io.vertx.axle.core.eventbus.EventBus removeInboundInterceptor(Consumer<io.vertx.axle.core.eventbus.DeliveryContext<T>> interceptor) {
    return __removeInboundInterceptor(interceptor != null ? interceptor::accept : null);
  }

  /**
   * Register a message codec.
   * <p>
   * You can register a message codec if you want to send any non standard message across the event bus.
   * E.g. you might want to send POJOs directly across the event bus.
   * <p>
   * To use a message codec for a send, you should specify it in the delivery options.
   * @param codec the message codec to register
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.eventbus.EventBus registerCodec(MessageCodec codec) { 
    io.vertx.axle.core.eventbus.EventBus ret = io.vertx.axle.core.eventbus.EventBus.newInstance(delegate.registerCodec(codec));
    return ret;
  }

  /**
   * Unregister a message codec.
   * <p>
   * @param name the name of the codec
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.eventbus.EventBus unregisterCodec(String name) { 
    io.vertx.axle.core.eventbus.EventBus ret = io.vertx.axle.core.eventbus.EventBus.newInstance(delegate.unregisterCodec(name));
    return ret;
  }


  public static  EventBus newInstance(io.vertx.core.eventbus.EventBus arg) {
    return arg != null ? new EventBus(arg) : null;
  }
}
