/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.eventbus;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements io.vertx.axle.core.streams.WriteStream<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageProducer that = (MessageProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<MessageProducer> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer<T> delegate;
  public final io.vertx.lang.axle.TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, io.vertx.lang.axle.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MessageProducer() {    this.delegate = null;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  private void __end(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public CompletionStage<Void> end(T data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.axle.core.eventbus.MessageProducer#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.MessageProducer#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param message the message to send
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return reference to this for fluency
   */
  @Deprecated()
  private <R> io.vertx.axle.core.eventbus.MessageProducer<T> __send(T message, Handler<AsyncResult<io.vertx.axle.core.eventbus.Message<R>>> replyHandler) { 
    io.vertx.axle.core.eventbus.MessageProducer<T> ret = io.vertx.axle.core.eventbus.MessageProducer.newInstance(delegate.send(__typeArg_0.<T>unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.eventbus.Message.newInstance(ar.result(), io.vertx.lang.axle.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.axle.core.eventbus.MessageProducer#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * @param message the message to send
   * @return reference to this for fluency
   */
  @Deprecated()
  public <R> CompletionStage<io.vertx.axle.core.eventbus.Message<R>> send(T message) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(message, handler);
    });
  }

  private io.vertx.axle.core.eventbus.MessageProducer<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageProducer<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.eventbus.MessageProducer<T> __write(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
    return this;
  }

  public CompletionStage<Void> write(T data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __write(data, handler);
    });
  }

  public io.vertx.axle.core.eventbus.MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.axle.core.eventbus.MessageProducer<T> __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.axle.core.eventbus.MessageProducer<T> drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public io.vertx.axle.core.eventbus.MessageProducer<T> deliveryOptions(DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Closes the producer, calls {@link io.vertx.axle.core.eventbus.MessageProducer#close}
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Closes the producer, calls {@link io.vertx.axle.core.eventbus.MessageProducer#close}
   * @return 
   */
  public CompletionStage<Void> end() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.axle.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = io.vertx.core.eventbus.MessageProducer.DEFAULT_WRITE_QUEUE_MAX_SIZE;

  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }

  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, io.vertx.lang.axle.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }
}
