/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.http;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;

/**
 * A WebSocket frame that represents either text or binary data.
 * <p>
 * A WebSocket message is composed of one or more WebSocket frames.
 * <p>
 * If there is a just a single frame in the message then a single text or binary frame should be created with final = true.
 * <p>
 * If there are more than one frames in the message, then the first frame should be a text or binary frame with
 * final = false, followed by one or more continuation frames. The last continuation frame should have final = true.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketFrame original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.http.WebSocketFrame.class)
public class WebSocketFrame {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketFrame that = (WebSocketFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<WebSocketFrame> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new WebSocketFrame((io.vertx.core.http.WebSocketFrame) obj),
    WebSocketFrame::getDelegate
  );

  private final io.vertx.core.http.WebSocketFrame delegate;
  
  public WebSocketFrame(io.vertx.core.http.WebSocketFrame delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WebSocketFrame() {    this.delegate = null;
  }

  public io.vertx.core.http.WebSocketFrame getDelegate() {
    return delegate;
  }

  /**
   * Create a binary WebSocket frame.
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.axle.core.http.WebSocketFrame binaryFrame(io.vertx.axle.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.axle.core.http.WebSocketFrame ret = io.vertx.axle.core.http.WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.binaryFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * Create a text WebSocket frame.
   * @param str the string for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.axle.core.http.WebSocketFrame textFrame(String str, boolean isFinal) { 
    io.vertx.axle.core.http.WebSocketFrame ret = io.vertx.axle.core.http.WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.textFrame(str, isFinal));
    return ret;
  }

  /**
   * Create a ping WebSocket frame.  Will be a final frame. There is no option for non final ping frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.axle.core.http.WebSocketFrame pingFrame(io.vertx.axle.core.buffer.Buffer data) { 
    io.vertx.axle.core.http.WebSocketFrame ret = io.vertx.axle.core.http.WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.pingFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a pong WebSocket frame.  Will be a final frame. There is no option for non final pong frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.axle.core.http.WebSocketFrame pongFrame(io.vertx.axle.core.buffer.Buffer data) { 
    io.vertx.axle.core.http.WebSocketFrame ret = io.vertx.axle.core.http.WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.pongFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a continuation frame
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.axle.core.http.WebSocketFrame continuationFrame(io.vertx.axle.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.axle.core.http.WebSocketFrame ret = io.vertx.axle.core.http.WebSocketFrame.newInstance(io.vertx.core.http.WebSocketFrame.continuationFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * @return true if it's a text frame
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return true if it's a binary frame
   */
  public boolean isBinary() { 
    boolean ret = delegate.isBinary();
    return ret;
  }

  /**
   * @return true if it's a continuation frame
   */
  public boolean isContinuation() { 
    boolean ret = delegate.isContinuation();
    return ret;
  }

  /**
   * @return true if it's close frame
   */
  public boolean isClose() { 
    boolean ret = delegate.isClose();
    return ret;
  }

  /**
   * @return the content of this frame as a UTF-8 string and returns the converted string. Only use this for text frames.
   */
  public String textData() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.textData();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the data of the frame
   */
  public io.vertx.axle.core.buffer.Buffer binaryData() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.buffer.Buffer ret = io.vertx.axle.core.buffer.Buffer.newInstance(delegate.binaryData());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this is the final frame.
   */
  public boolean isFinal() { 
    boolean ret = delegate.isFinal();
    return ret;
  }

  /**
   * @return status code of close frame. Only use this for close frames
   */
  public short closeStatusCode() { 
    short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return string explaining close reason. Only use this for close frames
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  private String cached_0;
  private io.vertx.axle.core.buffer.Buffer cached_1;

  public static  WebSocketFrame newInstance(io.vertx.core.http.WebSocketFrame arg) {
    return arg != null ? new WebSocketFrame(arg) : null;
  }
}
