/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.axle.core.http;

import io.vertx.axle.AsyncResultCompletionStage;
import io.vertx.axle.core.net.SocketAddress;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.lang.axle.Gen;
import io.vertx.lang.axle.TypeArg;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;

@Gen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConnection that = (HttpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    HttpConnection() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.axle.core.buffer.Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
        return this;
    }

    private HttpConnection __goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection goAwayHandler(Consumer<GoAway> handler) {
        return this.__goAwayHandler(handler != null ? handler::accept : null);
    }

    private HttpConnection __shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Consumer<Void> handler) {
        return this.__shutdownHandler(handler != null ? handler::accept : null);
    }

    public HttpConnection shutdown() {
        this.delegate.shutdown();
        return this;
    }

    public HttpConnection shutdown(long timeoutMs) {
        this.delegate.shutdown(timeoutMs);
        return this;
    }

    private HttpConnection __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpConnection closeHandler(Consumer<Void> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    public void close() {
        this.delegate.close();
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    private HttpConnection __updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.updateSettings(settings, completionHandler);
        return this;
    }

    public CompletionStage<Void> updateSettings(Http2Settings settings) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__updateSettings(settings, (Handler<AsyncResult<Void>>)handler));
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    private HttpConnection __remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public HttpConnection remoteSettingsHandler(Consumer<Http2Settings> handler) {
        return this.__remoteSettingsHandler(handler != null ? handler::accept : null);
    }

    private HttpConnection __ping(io.vertx.axle.core.buffer.Buffer data, final Handler<AsyncResult<io.vertx.axle.core.buffer.Buffer>> pongHandler) {
        this.delegate.ping(data.getDelegate(), (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    pongHandler.handle((Object)Future.succeededFuture((Object)io.vertx.axle.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    pongHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public CompletionStage<io.vertx.axle.core.buffer.Buffer> ping(io.vertx.axle.core.buffer.Buffer data) {
        return AsyncResultCompletionStage.toCompletionStage(handler -> this.__ping(data, (Handler<AsyncResult<io.vertx.axle.core.buffer.Buffer>>)handler));
    }

    private HttpConnection __pingHandler(final Handler<io.vertx.axle.core.buffer.Buffer> handler) {
        this.delegate.pingHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.axle.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpConnection pingHandler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
        return this.__pingHandler(handler != null ? handler::accept : null);
    }

    private HttpConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

