package io.vertx.mutiny.ext.auth.authorization;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Interface representing any kind of authorization such as:
 * <ul>
 *   <li>Role based authorization
 *   <li>Permission based authorization
 *   <li>Logical authorization (AND, OR, NOT)
 *   <li>Time based authorization (ie: allow access the last 5 days of the month, from 8am till 10am, etc.)
 *   <li>Context based authorization (ie: allow access if the ip address is 'xxx.xxx.xxx.xxx')
 *   <li>Custom based authorization (ie: based on a script or hard-coded code specific to an application)
 *   <li>etc.
 * </ul>
 * The following implementations are provided out of the box:
 * <ul>
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.AndAuthorization}
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.NotAuthorization}
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.OrAuthorization}
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.PermissionBasedAuthorization}
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.RoleBasedAuthorization}
 *   <li>{@link io.vertx.mutiny.ext.auth.authorization.WildcardPermissionBasedAuthorization}
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.Authorization original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.authorization.Authorization.class)
public class Authorization {

  public static final io.smallrye.mutiny.vertx.TypeArg<Authorization> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Authorization((io.vertx.ext.auth.authorization.Authorization) obj),
    Authorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.Authorization delegate;
  
  public Authorization(io.vertx.ext.auth.authorization.Authorization delegate) {
    this.delegate = delegate;
  }

  public Authorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorization)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Authorization() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.authorization.Authorization getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Authorization that = (Authorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.mutiny.ext.auth.authorization.AuthorizationContext context) { 
    boolean ret = delegate.match(context.getDelegate());
    return ret;
  }

  /**
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.mutiny.ext.auth.authorization.Authorization authorization) { 
    boolean ret = delegate.verify(authorization.getDelegate());
    return ret;
  }

  /**
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.mutiny.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

  public static  Authorization newInstance(io.vertx.ext.auth.authorization.Authorization arg) {
    return arg != null ? new Authorization(arg) : null;
  }

}
