package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * The composite future wraps a list of {@link io.vertx.mutiny.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 * The handlers set for the coordinated futures are overridden by the handler of the composite future.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.CompositeFuture.class)
public class CompositeFuture extends io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CompositeFuture> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CompositeFuture((io.vertx.core.CompositeFuture) obj),
    CompositeFuture::getDelegate
  );

  private final io.vertx.core.CompositeFuture delegate;
  
  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  CompositeFuture() {    super(null);
    this.delegate = null;
  }

  public io.vertx.core.CompositeFuture getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CompositeFuture that = (CompositeFuture) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   */
  @Deprecated()
  public void complete(io.vertx.mutiny.core.CompositeFuture result) { 
    delegate.complete(result.getDelegate());
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   * @return false when the future is already completed
   */
  @Deprecated()
  public boolean tryComplete(io.vertx.mutiny.core.CompositeFuture result) { 
    boolean ret = delegate.tryComplete(result.getDelegate());
    return ret;
  }

  /**
   * The result of the operation. This will be null if the operation failed.
   * @return the result or null if the operation failed.
   */
  public io.vertx.mutiny.core.CompositeFuture result() { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(delegate.result());
    return ret;
  }

  /**
   * Alias for {@link io.vertx.mutiny.core.Future#compose}.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.mutiny.core.Future<U> flatMap(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.flatMap(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>mapper</code> function.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * Compose this future with a <code>successMapper</code> and <code>failureMapper</code> functions.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>successMapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * When this future (the one on which <code>compose</code> is called) fails, the <code>failureMapper</code> will be called with
   * the failure and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If any mapper function throws an exception, the returned future will be failed with this exception.<p>
   * @param successMapper the function mapping the success
   * @param failureMapper the function mapping the failure
   * @return the composed future
   */
  public <U> io.vertx.mutiny.core.Future<U> compose(Function<io.vertx.mutiny.core.CompositeFuture, io.vertx.mutiny.core.Future<U>> successMapper, Function<Throwable, io.vertx.mutiny.core.Future<U>> failureMapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        io.vertx.mutiny.core.Future<U> ret = successMapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }, new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<U> ret = failureMapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> io.vertx.mutiny.core.Future<U> map(Function<io.vertx.mutiny.core.CompositeFuture, U> mapper) { 
    io.vertx.mutiny.core.Future<U> ret = io.vertx.mutiny.core.Future.newInstance(delegate.map(new java.util.function.Function<io.vertx.core.CompositeFuture,U>() {
      public U apply(io.vertx.core.CompositeFuture arg) {
        U ret = mapper.apply(io.vertx.mutiny.core.CompositeFuture.newInstance(arg));
        return ret;
      }
    }), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  @Deprecated()
  public Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> ret = new Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.mutiny.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * Handles a failure of this Future by returning the result of another Future.
   * If the mapper fails, then the returned future will be failed with this failure.
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> recover(Function<Throwable, io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture>> mapper) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<io.vertx.core.CompositeFuture>>() {
      public io.vertx.core.Future<io.vertx.core.CompositeFuture> apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future fails, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwise(Function<Throwable, io.vertx.mutiny.core.CompositeFuture> mapper) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,io.vertx.core.CompositeFuture>() {
      public io.vertx.core.CompositeFuture apply(java.lang.Throwable arg) {
        io.vertx.mutiny.core.CompositeFuture ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Map the failure of a future to a specific <code>value</code>.<p>
   *
   * When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwise(io.vertx.mutiny.core.CompositeFuture value) { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwise(value.getDelegate()), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Map the failure of a future to <code>null</code>.<p>
   *
   * This is a convenience for <code>future.otherwise((T) null)</code>.<p>
   *
   * When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @return the mapped future
   */
  public io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> otherwiseEmpty() { 
    io.vertx.mutiny.core.Future<io.vertx.mutiny.core.CompositeFuture> ret = io.vertx.mutiny.core.Future.newInstance(delegate.otherwiseEmpty(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * The returned future fails as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#all} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#all} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#all} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#all} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture all(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#all} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture all(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when any futures is succeeded, failed when all futures are failed.
   * <p/>
   * The returned future succeeds as soon as one of <code>f1</code> or <code>f2</code> succeeds.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#any} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#any} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#any} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#any} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture any(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#any} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture any(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * It always wait until all its futures are completed and will not fail as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#join} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#join} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#join} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#join} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> io.vertx.mutiny.core.CompositeFuture join(io.vertx.mutiny.core.Future<T1> f1, io.vertx.mutiny.core.Future<T2> f2, io.vertx.mutiny.core.Future<T3> f3, io.vertx.mutiny.core.Future<T4> f4, io.vertx.mutiny.core.Future<T5> f5, io.vertx.mutiny.core.Future<T6> f6) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.CompositeFuture#join} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static io.vertx.mutiny.core.CompositeFuture join(List<io.vertx.mutiny.core.Future> futures) { 
    io.vertx.mutiny.core.CompositeFuture ret = io.vertx.mutiny.core.CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  private io.vertx.mutiny.core.CompositeFuture __setHandler(Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Uni<io.vertx.mutiny.core.CompositeFuture> setHandler() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __setHandler(handler);
    });
  }

  public io.vertx.mutiny.core.CompositeFuture setHandlerAndAwait() { 
    return (io.vertx.mutiny.core.CompositeFuture) setHandler().await().indefinitely();
  }

  private io.vertx.mutiny.core.CompositeFuture __onComplete(Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> handler) { 
    delegate.onComplete(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  public Uni<io.vertx.mutiny.core.CompositeFuture> onComplete() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __onComplete(handler);
    });
  }

  public io.vertx.mutiny.core.CompositeFuture onCompleteAndAwait() { 
    return (io.vertx.mutiny.core.CompositeFuture) onComplete().await().indefinitely();
  }

  private io.vertx.mutiny.core.CompositeFuture __onSuccess(Handler<io.vertx.mutiny.core.CompositeFuture> handler) { 
    delegate.onSuccess(new Handler<io.vertx.core.CompositeFuture>() {
      public void handle(io.vertx.core.CompositeFuture event) {
        handler.handle(io.vertx.mutiny.core.CompositeFuture.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.CompositeFuture onSuccess(Consumer<io.vertx.mutiny.core.CompositeFuture> handler) {
    return __onSuccess(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.CompositeFuture __onFailure(Handler<Throwable> handler) { 
    delegate.onFailure(handler);
    return this;
  }

  public io.vertx.mutiny.core.CompositeFuture onFailure(Consumer<Throwable> handler) {
    return __onFailure(handler != null ? handler::accept : null);
  }

  /**
   * Set this instance as result. Any handler will be called, if there is one, and the future will be marked as completed.
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Try to set this instance as result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Returns a cause of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = delegate.cause(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is succeeded
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = delegate.succeeded(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is failed
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = delegate.failed(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is completed
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = delegate.isComplete(index);
    return ret;
  }

  /**
   * Returns the result of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public <T> T resultAt(int index) { 
    T ret = (T) delegate.resultAt(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  private Handler<AsyncResult<io.vertx.mutiny.core.CompositeFuture>> cached_0;
  public static  CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }

}
