package io.vertx.mutiny.core;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * This class represents a MultiMap of String keys to a List of String values.
 * <p>
 * It's useful in Vert.x to represent things in Vert.x like HTTP headers and HTTP parameters which allow
 * multiple values for keys.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.MultiMap original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.MultiMap.class)
public class MultiMap implements java.lang.Iterable<Entry<String, String>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MultiMap> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MultiMap((io.vertx.core.MultiMap) obj),
    MultiMap::getDelegate
  );

  private final io.vertx.core.MultiMap delegate;
  
  public MultiMap(io.vertx.core.MultiMap delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MultiMap() {    this.delegate = null;
  }

  public io.vertx.core.MultiMap getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultiMap that = (MultiMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public java.util.Iterator<Entry<String, String>> iterator() {
    return delegate.iterator();
  }

  /**
   * Create a multi-map implementation with case insensitive keys, for instance it can be used to hold some HTTP headers.
   * @return the multi-map
   */
  public static io.vertx.mutiny.core.MultiMap caseInsensitiveMultiMap() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
    return ret;
  }

  /**
   * Returns the value of with the specified name.  If there are
   * more than one values for the specified name, the first value is returned.
   * @param name The name of the header to search
   * @return The first header value or <code>null</code> if there is no such entry
   */
  public String get(String name) { 
    String ret = delegate.get(name);
    return ret;
  }

  /**
   * Returns the values with the specified name
   * @param name The name to search
   * @return A immutable {@link java.util.List} of values which will be empty if no values are found
   */
  public List<String> getAll(String name) { 
    List<String> ret = delegate.getAll(name);
    return ret;
  }

  /**
   * Checks to see if there is a value with the specified name
   * @param name The name to search for
   * @return true if at least one entry is found
   */
  public boolean contains(String name) { 
    boolean ret = delegate.contains(name);
    return ret;
  }

  /**
   * Check if there is a header with the specified <code>name</code> and <code>value</code>.
   *
   * If <code>caseInsensitive</code> is <code>true</code>, <code>value</code> is compared in a case-insensitive way.
   * @param name the name to search for
   * @param value the value to search for
   * @param caseInsensitive 
   * @return <code>true</code> if at least one entry is found
   */
  public boolean contains(String name, String value, boolean caseInsensitive) { 
    boolean ret = delegate.contains(name, value, caseInsensitive);
    return ret;
  }

  /**
   * Return true if empty
   * @return 
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * Gets a immutable {@link java.util.Set} of all names
   * @return A {@link java.util.Set} of all names
   */
  public Set<String> names() { 
    Set<String> ret = delegate.names();
    return ret;
  }

  /**
   * Adds a new value with the specified name and value.
   * @param name The name
   * @param value The value being added
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap add(String name, String value) { 
    delegate.add(name, value);
    return this;
  }

  /**
   * Adds all the entries from another MultiMap to this one
   * @param map 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap addAll(io.vertx.mutiny.core.MultiMap map) { 
    delegate.addAll(map.getDelegate());
    return this;
  }

  /**
   * Sets a value under the specified name.
   * <p>
   * If there is an existing header with the same name, it is removed.
   * @param name The name
   * @param value The value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap set(String name, String value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * Cleans this instance.
   * @param map 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap setAll(io.vertx.mutiny.core.MultiMap map) { 
    delegate.setAll(map.getDelegate());
    return this;
  }

  /**
   * Removes the value with the given name
   * @param name The name of the value to remove
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap remove(String name) { 
    delegate.remove(name);
    return this;
  }

  /**
   * Removes all
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap clear() { 
    delegate.clear();
    return this;
  }

  /**
   * Return the number of keys.
   * @return 
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public String get(CharSequence name) { 
    String ret = delegate.get(name);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#getAll} but accepting a <code>CharSequence</code> as a parameter
   * @param name 
   * @return 
   */
  public List<String> getAll(CharSequence name) { 
    List<String> ret = delegate.getAll(name);
    return ret;
  }

  /**
   * Returns all entries in the multi-map.
   * @return A immutable {@link java.util.List} of the name-value entries, which will be empty if no pairs are found
   */
  public List<Entry<String, String>> entries() { 
    List<Entry<String, String>> ret = delegate.entries();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#contains} but accepting a <code>CharSequence</code> as a parameter
   * @param name 
   * @return 
   */
  public boolean contains(CharSequence name) { 
    boolean ret = delegate.contains(name);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#contains} but accepting <code>CharSequence</code> parameters.
   * @param name 
   * @param value 
   * @param caseInsensitive 
   * @return 
   */
  public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) { 
    boolean ret = delegate.contains(name, value, caseInsensitive);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#add} but accepting <code>CharSequence</code> as parameters
   * @param name 
   * @param value 
   * @return 
   */
  public io.vertx.mutiny.core.MultiMap add(CharSequence name, CharSequence value) { 
    delegate.add(name, value);
    return this;
  }

  /**
   * Adds a new values under the specified name
   * @param name The name being set
   * @param values The values
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap add(String name, Iterable<String> values) { 
    delegate.add(name, values);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#add} but accepting <code>CharSequence</code> as parameters
   * @param name 
   * @param values 
   * @return 
   */
  public io.vertx.mutiny.core.MultiMap add(CharSequence name, Iterable<CharSequence> values) { 
    delegate.add(name, values);
    return this;
  }

  /**
   * Adds all the entries from a Map to this
   * @param headers 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap addAll(Map<String, String> headers) { 
    delegate.addAll(headers);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#set} but accepting <code>CharSequence</code> as parameters
   * @param name 
   * @param value 
   * @return 
   */
  public io.vertx.mutiny.core.MultiMap set(CharSequence name, CharSequence value) { 
    delegate.set(name, value);
    return this;
  }

  /**
   * Sets values for the specified name.
   * @param name The name of the headers being set
   * @param values The values of the headers being set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap set(String name, Iterable<String> values) { 
    delegate.set(name, values);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#set} but accepting <code>CharSequence</code> as parameters
   * @param name 
   * @param values 
   * @return 
   */
  public io.vertx.mutiny.core.MultiMap set(CharSequence name, Iterable<CharSequence> values) { 
    delegate.set(name, values);
    return this;
  }

  /**
   * Cleans and set all values of the given instance
   * @param headers 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.MultiMap setAll(Map<String, String> headers) { 
    delegate.setAll(headers);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.MultiMap#remove} but accepting <code>CharSequence</code> as parameters
   * @param name 
   * @return 
   */
  public io.vertx.mutiny.core.MultiMap remove(CharSequence name) { 
    delegate.remove(name);
    return this;
  }

  public static  MultiMap newInstance(io.vertx.core.MultiMap arg) {
    return arg != null ? new MultiMap(arg) : null;
  }

}
