package io.vertx.mutiny.core.datagram;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A datagram socket can be used to send {@link io.vertx.mutiny.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.mutiny.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.datagram.DatagramPacket>, io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<DatagramSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DatagramSocket() {    this.delegate = null;
  }

  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.datagram.DatagramPacket> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.datagram.DatagramPacket> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.datagram.DatagramPacket.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Write the given {@link io.vertx.mutiny.core.buffer.Buffer} to the {@link io.vertx.mutiny.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __send(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.send(packet.getDelegate(), port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link io.vertx.mutiny.core.buffer.Buffer} to the {@link io.vertx.mutiny.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> send(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(packet, port, host, handler);
    });
  }

  /**
   * Write the given {@link io.vertx.mutiny.core.buffer.Buffer} to the {@link io.vertx.mutiny.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.mutiny.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndAwait(io.vertx.mutiny.core.buffer.Buffer packet, int port, String host) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) send(packet, port, host).await().indefinitely();
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.mutiny.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> sender(int port, String host) { 
    io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.WriteStream.newInstance(delegate.sender(port, host), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __send(String str, int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> send(String str, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(str, port, host, handler);
    });
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndAwait(String str, int port, String host) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) send(str, port, host).await().indefinitely();
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __send(String str, String enc, int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, enc, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> send(String str, String enc, int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(str, enc, port, host, handler);
    });
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.mutiny.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket sendAndAwait(String str, String enc, int port, String host) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) send(str, enc, port, host).await().indefinitely();
  }

  /**
   * Closes the {@link io.vertx.mutiny.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @param handler the handler to notify once complete
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the {@link io.vertx.mutiny.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Closes the {@link io.vertx.mutiny.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Return the {@link io.vertx.mutiny.core.net.SocketAddress} to which
   * this {@link io.vertx.mutiny.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __listenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> listenMulticastGroup(String multicastAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket listenMulticastGroupAndAwait(String multicastAddress) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) listenMulticastGroup(multicastAddress).await().indefinitely();
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> listenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket listenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) listenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> unlistenMulticastGroup(String multicastAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __unlistenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket unlistenMulticastGroupAndAwait(String multicastAddress) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) unlistenMulticastGroup(multicastAddress).await().indefinitely();
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket unlistenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) unlistenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> blockMulticastGroup(String multicastAddress, String sourceToBlock) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __blockMulticastGroup(multicastAddress, sourceToBlock, handler);
    });
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket blockMulticastGroupAndAwait(String multicastAddress, String sourceToBlock) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) blockMulticastGroup(multicastAddress, sourceToBlock).await().indefinitely();
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
    });
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket blockMulticastGroupAndAwait(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).await().indefinitely();
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param handler the handler will be called when listening
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.datagram.DatagramSocket __listen(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.datagram.DatagramSocket>> handler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.datagram.DatagramSocket> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.datagram.DatagramSocket listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.datagram.DatagramSocket) listen(port, host).await().indefinitely();
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.mutiny.core.datagram.DatagramSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.mutiny.core.datagram.DatagramSocket __handler(Handler<io.vertx.mutiny.core.datagram.DatagramPacket> handler) { 
    delegate.handler(new Handler<io.vertx.core.datagram.DatagramPacket>() {
      public void handle(io.vertx.core.datagram.DatagramPacket event) {
        handler.handle(io.vertx.mutiny.core.datagram.DatagramPacket.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket handler(Consumer<io.vertx.mutiny.core.datagram.DatagramPacket> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.datagram.DatagramSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.datagram.DatagramSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.datagram.DatagramPacket> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Closes the {@link io.vertx.mutiny.core.datagram.DatagramSocket}. The close itself is asynchronous.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private Multi<io.vertx.mutiny.core.datagram.DatagramPacket> multi;
  public synchronized Multi<io.vertx.mutiny.core.datagram.DatagramPacket> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.mutiny.core.datagram.DatagramPacket> conv = io.vertx.mutiny.core.datagram.DatagramPacket::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.datagram.DatagramPacket> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.datagram.DatagramPacket> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
