package io.vertx.mutiny.core.dns;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<DnsClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DnsClient() {    this.delegate = null;
  }

  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.dns.DnsClient __lookup(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<String> lookup(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __lookup(name, handler);
    });
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public String lookupAndAwait(String name) { 
    return (String) lookup(name).await().indefinitely();
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with the resolved {@link java.net.Inet4Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.dns.DnsClient __lookup4(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup4(name, handler);
    return this;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<String> lookup4(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __lookup4(name, handler);
    });
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public String lookup4AndAwait(String name) { 
    return (String) lookup4(name).await().indefinitely();
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.net.Inet6Address} if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.dns.DnsClient __lookup6(String name, Handler<AsyncResult<String>> handler) { 
    delegate.lookup6(name, handler);
    return this;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<String> lookup6(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __lookup6(name, handler);
    });
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public String lookup6AndAwait(String name) { 
    return (String) lookup6(name).await().indefinitely();
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet4Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveA(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveA(name, handler);
    return this;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<List<String>> resolveA(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveA(name, handler);
    });
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public List<String> resolveAAndAwait(String name) { 
    return (List<String>) resolveA(name).await().indefinitely();
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet6Address}es. If none was found an empty {@link java.util.List} will be used. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveAAAA(name, handler);
    return this;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<List<String>> resolveAAAA(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveAAAA(name, handler);
    });
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a reference to this, so the API can be used fluently
   */
  public List<String> resolveAAAAAndAwait(String name) { 
    return (List<String>) resolveAAAA(name).await().indefinitely();
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveCNAME(name, handler);
    return this;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<List<String>> resolveCNAME(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveCNAME(name, handler);
    });
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a reference to this, so the API can be used fluently.
   */
  public List<String> resolveCNAMEAndAwait(String name) { 
    return (List<String>) resolveCNAME(name).await().indefinitely();
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @param handler the {@link io.vertx.core.Handler} to notify with the {@link io.vertx.core.AsyncResult}. The handler will get notified with a List that contains all resolved {@link io.vertx.mutiny.core.dns.MxRecord}s, sorted by their {@link io.vertx.mutiny.core.dns.MxRecord#priority}. If non was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveMX(String name, Handler<AsyncResult<List<io.vertx.mutiny.core.dns.MxRecord>>> handler) { 
    delegate.resolveMX(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.MxRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.mutiny.core.dns.MxRecord.newInstance(elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<List<io.vertx.mutiny.core.dns.MxRecord>> resolveMX(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveMX(name, handler);
    });
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public List<io.vertx.mutiny.core.dns.MxRecord> resolveMXAndAwait(String name) { 
    return (List<io.vertx.mutiny.core.dns.MxRecord>) resolveMX(name).await().indefinitely();
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveTXT(name, handler);
    return this;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<List<String>> resolveTXT(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveTXT(name, handler);
    });
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public List<String> resolveTXTAndAwait(String name) { 
    return (List<String>) resolveTXT(name).await().indefinitely();
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolvePTR(String name, Handler<AsyncResult<String>> handler) { 
    delegate.resolvePTR(name, handler);
    return this;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<String> resolvePTR(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolvePTR(name, handler);
    });
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public String resolvePTRAndAwait(String name) { 
    return (String) resolvePTR(name).await().indefinitely();
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveNS(String name, Handler<AsyncResult<List<String>>> handler) { 
    delegate.resolveNS(name, handler);
    return this;
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<List<String>> resolveNS(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveNS(name, handler);
    });
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public List<String> resolveNSAndAwait(String name) { 
    return (List<String>) resolveNS(name).await().indefinitely();
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @param handler the  to notify with the . The handler will get notified with a List that contains all resolved {@link io.vertx.mutiny.core.dns.SrvRecord}s. If none was found it will get notified with an empty {@link java.util.List}. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __resolveSRV(String name, Handler<AsyncResult<List<io.vertx.mutiny.core.dns.SrvRecord>>> handler) { 
    delegate.resolveSRV(name, new Handler<AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.core.dns.SrvRecord>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.mutiny.core.dns.SrvRecord.newInstance(elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<List<io.vertx.mutiny.core.dns.SrvRecord>> resolveSRV(String name) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resolveSRV(name, handler);
    });
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a reference to this, so the API can be used fluently.
   */
  public List<io.vertx.mutiny.core.dns.SrvRecord> resolveSRVAndAwait(String name) { 
    return (List<io.vertx.mutiny.core.dns.SrvRecord>) resolveSRV(name).await().indefinitely();
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @param handler the  to notify with the . The handler will get notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
   * @return a reference to this, so the API can be used fluently.
   */
  private io.vertx.mutiny.core.dns.DnsClient __reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) { 
    delegate.reverseLookup(ipaddress, handler);
    return this;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public Uni<String> reverseLookup(String ipaddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __reverseLookup(ipaddress, handler);
    });
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a reference to this, so the API can be used fluently.
   */
  public String reverseLookupAndAwait(String ipaddress) { 
    return (String) reverseLookup(ipaddress).await().indefinitely();
  }

  public static  DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }

}
