package io.vertx.mutiny.core.dns;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 * Represent a Service-Record (SRV) which was resolved for a domain.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.SrvRecord original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.dns.SrvRecord.class)
public class SrvRecord {

  public static final io.smallrye.mutiny.vertx.TypeArg<SrvRecord> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SrvRecord((io.vertx.core.dns.SrvRecord) obj),
    SrvRecord::getDelegate
  );

  private final io.vertx.core.dns.SrvRecord delegate;
  
  public SrvRecord(io.vertx.core.dns.SrvRecord delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  SrvRecord() {    this.delegate = null;
  }

  public io.vertx.core.dns.SrvRecord getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SrvRecord that = (SrvRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Returns the priority for this service record.
   * @return 
   */
  public int priority() { 
    int ret = delegate.priority();
    return ret;
  }

  /**
   * Returns the weight of this service record.
   * @return 
   */
  public int weight() { 
    int ret = delegate.weight();
    return ret;
  }

  /**
   * Returns the port the service is running on.
   * @return 
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * Returns the name for the server being queried.
   * @return 
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * Returns the protocol for the service being queried (i.e. "_tcp").
   * @return 
   */
  public String protocol() { 
    String ret = delegate.protocol();
    return ret;
  }

  /**
   * Returns the service's name (i.e. "_http").
   * @return 
   */
  public String service() { 
    String ret = delegate.service();
    return ret;
  }

  /**
   * Returns the name of the host for the service.
   * @return 
   */
  public String target() { 
    String ret = delegate.target();
    return ret;
  }

  public static  SrvRecord newInstance(io.vertx.core.dns.SrvRecord arg) {
    return arg != null ? new SrvRecord(arg) : null;
  }

}
