package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a message that is received from the event bus in a handler.
 * <p>
 * Messages have a {@link io.vertx.mutiny.core.eventbus.Message#body}, which can be null, and also {@link io.vertx.mutiny.core.eventbus.Message#headers}, which can be empty.
 * <p>
 * If the message was sent specifying a reply handler, it can be replied to using {@link io.vertx.mutiny.core.eventbus.Message#reply}.
 * <p>
 * If you want to notify the sender that processing failed, then {@link io.vertx.mutiny.core.eventbus.Message#fail} can be called.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.Message original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.Message.class)
public class Message<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Message> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Message((io.vertx.core.eventbus.Message) obj),
    Message::getDelegate
  );

  private final io.vertx.core.eventbus.Message<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Message(io.vertx.core.eventbus.Message delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Message(io.vertx.core.eventbus.Message delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Message() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.Message getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Message that = (Message) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * The address the message was sent to
   * @return 
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Multi-map of message headers. Can be empty
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * The body of the message. Can be null.
   * @return the body, or null.
   */
  public T body() { 
    if (cached_0 != null) {
      return cached_0;
    }
    T ret = (T)__typeArg_0.wrap(delegate.body());
    cached_0 = ret;
    return ret;
  }

  /**
   * The reply address. Can be null.
   * @return the reply address, or null, if message was sent without a reply handler.
   */
  public String replyAddress() { 
    String ret = delegate.replyAddress();
    return ret;
  }

  /**
   * Signals if this message represents a send or publish event.
   * @return true if this is a send.
   */
  public boolean isSend() { 
    boolean ret = delegate.isSend();
    return ret;
  }

  /**
   * The same as <code>reply(R message)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the message to reply with.
   * @param replyHandler the reply handler for the reply.
   */
  @Deprecated()
  private <R> void __reply(Object message, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<R>>> replyHandler) { 
    delegate.reply(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * The same as <code>reply(R message)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the message to reply with.
   * @return 
   */
  @Deprecated()
  public <R> Uni<io.vertx.mutiny.core.eventbus.Message<R>> reply(Object message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __reply(message, handler);
    });
  }

  /**
   * The same as <code>reply(R message)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the message to reply with.
   * @return 
   */
  @Deprecated()
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndAwait(Object message) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) reply(message).await().indefinitely();
  }

  /**
   * The same as <code>reply(R message, DeliveryOptions)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the reply message
   * @param options the delivery options
   * @param replyHandler the reply handler for the reply.
   */
  @Deprecated()
  private <R> void __reply(Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<R>>> replyHandler) { 
    delegate.reply(message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * The same as <code>reply(R message, DeliveryOptions)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the reply message
   * @param options the delivery options
   * @return 
   */
  @Deprecated()
  public <R> Uni<io.vertx.mutiny.core.eventbus.Message<R>> reply(Object message, DeliveryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __reply(message, options, handler);
    });
  }

  /**
   * The same as <code>reply(R message, DeliveryOptions)</code> but you can specify handler for the reply - i.e.
   * to receive the reply to the reply.
   * @param message the reply message
   * @param options the delivery options
   * @return 
   */
  @Deprecated()
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndAwait(Object message, DeliveryOptions options) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) reply(message, options).await().indefinitely();
  }

  /**
   * Reply to this message, specifying a <code>replyHandler</code> for the reply - i.e.
   * to receive the reply to the reply.
   * <p>
   * If the message was sent specifying a reply handler, that handler will be
   * called when it has received a reply. If the message wasn't sent specifying a receipt handler
   * this method does nothing.
   * @param message the message to reply with.
   * @param replyHandler the reply handler for the reply.
   */
  private <R> void __replyAndRequest(Object message, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<R>>> replyHandler) { 
    delegate.replyAndRequest(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Reply to this message, specifying a <code>replyHandler</code> for the reply - i.e.
   * to receive the reply to the reply.
   * <p>
   * If the message was sent specifying a reply handler, that handler will be
   * called when it has received a reply. If the message wasn't sent specifying a receipt handler
   * this method does nothing.
   * @param message the message to reply with.
   * @return 
   */
  public <R> Uni<io.vertx.mutiny.core.eventbus.Message<R>> replyAndRequest(Object message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __replyAndRequest(message, handler);
    });
  }

  /**
   * Reply to this message, specifying a <code>replyHandler</code> for the reply - i.e.
   * to receive the reply to the reply.
   * <p>
   * If the message was sent specifying a reply handler, that handler will be
   * called when it has received a reply. If the message wasn't sent specifying a receipt handler
   * this method does nothing.
   * @param message the message to reply with.
   * @return 
   */
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndRequestAndAwait(Object message) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) replyAndRequest(message).await().indefinitely();
  }

  /**
   * Like  but specifying <code>options</code> that can be used
   * to configure the delivery.
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @param replyHandler reply handler will be called when any reply from the recipient is received
   */
  private <R> void __replyAndRequest(Object message, DeliveryOptions options, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<R>>> replyHandler) { 
    delegate.replyAndRequest(message, options, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like  but specifying <code>options</code> that can be used
   * to configure the delivery.
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return 
   */
  public <R> Uni<io.vertx.mutiny.core.eventbus.Message<R>> replyAndRequest(Object message, DeliveryOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __replyAndRequest(message, options, handler);
    });
  }

  /**
   * Like  but specifying <code>options</code> that can be used
   * to configure the delivery.
   * @param message the message body, may be <code>null</code>
   * @param options delivery options
   * @return 
   */
  public <R> io.vertx.mutiny.core.eventbus.Message<R> replyAndRequestAndAwait(Object message, DeliveryOptions options) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) replyAndRequest(message, options).await().indefinitely();
  }

  /**
   * Signal to the sender that processing of this message failed.
   * <p>
   * If the message was sent specifying a result handler
   * the handler will be called with a failure corresponding to the failure code and message specified here.
   * @param failureCode A failure code to pass back to the sender
   * @param message A message to pass back to the sender
   */
  public void fail(int failureCode, String message) { 
    delegate.fail(failureCode, message);
  }

  /**
   * Reply to this message.
   * <p>
   * If the message was sent specifying a reply handler, that handler will be
   * called when it has received a reply. If the message wasn't sent specifying a receipt handler
   * this method does nothing.
   * @param message the message to reply with.
   */
  public void replyAndForget(Object message) { 
    delegate.reply(message);
  }

  /**
   * Link {@link io.vertx.mutiny.core.eventbus.Message#reply} but allows you to specify delivery options for the reply.
   * @param message the reply message
   * @param options the delivery options
   */
  public void replyAndForget(Object message, DeliveryOptions options) { 
    delegate.reply(message, options);
  }

  private T cached_0;
  public static <T>Message<T> newInstance(io.vertx.core.eventbus.Message arg) {
    return arg != null ? new Message<T>(arg) : null;
  }


  public static <T>Message<T> newInstance(io.vertx.core.eventbus.Message arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Message<T>(arg, __typeArg_T) : null;
  }

}
