package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.mutiny.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.mutiny.core.eventbus.EventBus#consumer} or {@link io.vertx.mutiny.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.mutiny.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.mutiny.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.mutiny.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.eventbus.Message<T>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MessageConsumer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MessageConsumer() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.eventbus.Message<T>> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.eventbus.Message<T>> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.eventbus.Message.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __handler(Handler<io.vertx.mutiny.core.eventbus.Message<T>> handler) { 
    delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.mutiny.core.eventbus.Message.newInstance(event, __typeArg_0));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> handler(Consumer<io.vertx.mutiny.core.eventbus.Message<T>> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.mutiny.core.eventbus.MessageConsumer<T> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public io.vertx.mutiny.core.streams.ReadStream<T> bodyStream() { 
    io.vertx.mutiny.core.streams.ReadStream<T> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Set the number of messages this registration will buffer when this stream is paused. The default
   * value is <code>1000</code>.
   * <p>
   * When a new value is set, buffered messages may be discarded to reach the new value. The most recent
   * messages will be kept.
   * @param maxBufferedMessages the maximum number of messages that can be buffered
   * @return this registration
   */
  public io.vertx.mutiny.core.eventbus.MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) { 
    io.vertx.mutiny.core.eventbus.MessageConsumer<T> ret = io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance(delegate.setMaxBufferedMessages(maxBufferedMessages), __typeArg_0);
    return ret;
  }

  /**
   * @return the maximum number of messages that can be buffered when this stream is paused
   */
  public int getMaxBufferedMessages() { 
    int ret = delegate.getMaxBufferedMessages();
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @param completionHandler the completion handler
   */
  private void __completionHandler(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.completionHandler(completionHandler);
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public Uni<Void> completionHandler() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __completionHandler(handler);
    });
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public Void completionHandlerAndAwait() { 
    return (Void) completionHandler().await().indefinitely();
  }

  /**
   * Unregisters the handler which created this registration
   * @param completionHandler the handler called when the unregister is done. For example in a cluster when all nodes of the event bus have been unregistered.
   */
  private void __unregister(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unregister(completionHandler);
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public Uni<Void> unregister() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __unregister(handler);
    });
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public Void unregisterAndAwait() { 
    return (Void) unregister().await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.eventbus.Message<T>> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Unregisters the handler which created this registration
   */
  public void unregisterAndForget() { 
    delegate.unregister();
  }

  private Multi<io.vertx.mutiny.core.eventbus.Message<T>> multi;
  public synchronized Multi<io.vertx.mutiny.core.eventbus.Message<T>> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.eventbus.Message<T>, io.vertx.mutiny.core.eventbus.Message<T>> conv = io.vertx.mutiny.core.eventbus.Message::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.eventbus.Message<T>> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.eventbus.Message<T>> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }


  public static <T>MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }

}
