package io.vertx.mutiny.core.file;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 * Represents properties of a file on the file system.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.FileProps original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.file.FileProps.class)
public class FileProps {

  public static final io.smallrye.mutiny.vertx.TypeArg<FileProps> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FileProps((io.vertx.core.file.FileProps) obj),
    FileProps::getDelegate
  );

  private final io.vertx.core.file.FileProps delegate;
  
  public FileProps(io.vertx.core.file.FileProps delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  FileProps() {    this.delegate = null;
  }

  public io.vertx.core.file.FileProps getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileProps that = (FileProps) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * The date the file was created
   * @return 
   */
  public long creationTime() { 
    long ret = delegate.creationTime();
    return ret;
  }

  /**
   * The date the file was last accessed
   * @return 
   */
  public long lastAccessTime() { 
    long ret = delegate.lastAccessTime();
    return ret;
  }

  /**
   * The date the file was last modified
   * @return 
   */
  public long lastModifiedTime() { 
    long ret = delegate.lastModifiedTime();
    return ret;
  }

  /**
   * Is the file a directory?
   * @return 
   */
  public boolean isDirectory() { 
    boolean ret = delegate.isDirectory();
    return ret;
  }

  /**
   * Is the file some other type? (I.e. not a directory, regular file or symbolic link)
   * @return 
   */
  public boolean isOther() { 
    boolean ret = delegate.isOther();
    return ret;
  }

  /**
   * Is the file a regular file?
   * @return 
   */
  public boolean isRegularFile() { 
    boolean ret = delegate.isRegularFile();
    return ret;
  }

  /**
   * Is the file a symbolic link?
   * @return 
   */
  public boolean isSymbolicLink() { 
    boolean ret = delegate.isSymbolicLink();
    return ret;
  }

  /**
   * The size of the file, in bytes
   * @return 
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  public static  FileProps newInstance(io.vertx.core.file.FileProps arg) {
    return arg != null ? new FileProps(arg) : null;
  }

}
