package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.mutiny.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.mutiny.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpServer() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the request stream for the server. As HTTP requests are received by the server,
   * instances of {@link io.vertx.mutiny.core.http.HttpServerRequest} will be created and passed to the stream .
   * @return the request stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.requestStream(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.http.HttpServerRequest.__TYPE_ARG);
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.mutiny.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __requestHandler(Handler<io.vertx.mutiny.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.mutiny.core.http.HttpServerRequest.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.mutiny.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer requestHandler(Consumer<io.vertx.mutiny.core.http.HttpServerRequest> handler) {
    return __requestHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set a connection handler for the server.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __connectionHandler(Handler<io.vertx.mutiny.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.mutiny.core.http.HttpConnection.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a connection handler for the server.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer connectionHandler(Consumer<io.vertx.mutiny.core.http.HttpConnection> handler) {
    return __connectionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Return the WebSocket stream for the server. If a webSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  @Deprecated()
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> websocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.websocketStream(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.http.ServerWebSocket.__TYPE_ARG);
    cached_1 = ret;
    return ret;
  }

  /**
   * Return the WebSocket stream for the server. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.webSocketStream(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.http.ServerWebSocket.__TYPE_ARG);
    cached_2 = ret;
    return ret;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  private io.vertx.mutiny.core.http.HttpServer __websocketHandler(Handler<io.vertx.mutiny.core.http.ServerWebSocket> handler) { 
    delegate.websocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.mutiny.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Deprecated()
  public io.vertx.mutiny.core.http.HttpServer websocketHandler(Consumer<io.vertx.mutiny.core.http.ServerWebSocket> handler) {
    return __websocketHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.HttpServer __webSocketHandler(Handler<io.vertx.mutiny.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.mutiny.core.http.ServerWebSocket.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.mutiny.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer webSocketHandler(Consumer<io.vertx.mutiny.core.http.ServerWebSocket> handler) {
    return __webSocketHandler(handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(port, host).await().indefinitely();
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(io.vertx.mutiny.core.net.SocketAddress address, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(io.vertx.mutiny.core.net.SocketAddress address) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(address, handler);
    });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(io.vertx.mutiny.core.net.SocketAddress address) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(address).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(int port, Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.core.http.HttpServer) listen(port).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param listenHandler the listen handler
   * @return 
   */
  private io.vertx.mutiny.core.http.HttpServer __listen(Handler<AsyncResult<io.vertx.mutiny.core.http.HttpServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public Uni<io.vertx.mutiny.core.http.HttpServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndAwait() { 
    return (io.vertx.mutiny.core.http.HttpServer) listen().await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @param completionHandler the handler
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified in the
   * {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget() { 
    delegate.listen();
    return this;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified here,
   * ignoring any value set in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServer#listen} but the server will listen on host "0.0.0.0" and port specified here ignoring
   * any value in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.HttpServer listenAndForget(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Close the server. Any open HTTP connections will be closed.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.HttpServerRequest> cached_0;
  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> cached_1;
  private io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.http.ServerWebSocket> cached_2;
  public static  HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
