package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an file upload from an HTML FORM.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerFileUpload original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServerFileUpload> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload) obj),
    HttpServerFileUpload::getDelegate
  );

  private final io.vertx.core.http.HttpServerFileUpload delegate;
  
  public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpServerFileUpload() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerFileUpload getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerFileUpload that = (HttpServerFileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.HttpServerFileUpload __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.HttpServerFileUpload __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.HttpServerFileUpload __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * @param filename the name of the file
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerFileUpload streamToFileSystem(String filename) { 
    delegate.streamToFileSystem(filename);
    return this;
  }

  /**
   * @return the filename which was used when upload the file.
   */
  public String filename() { 
    String ret = delegate.filename();
    return ret;
  }

  /**
   * @return the name of the attribute
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the content type for the upload
   */
  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the contentTransferEncoding for the upload
   */
  public String contentTransferEncoding() { 
    String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset for the upload
   */
  public String charset() { 
    String ret = delegate.charset();
    return ret;
  }

  /**
   * The size of the upload may not be available until it is all read.
   * Check {@link io.vertx.mutiny.core.http.HttpServerFileUpload#isSizeAvailable} to determine this
   * @return the size of the upload (in bytes)
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if the size of the upload can be retrieved via {@link io.vertx.mutiny.core.http.HttpServerFileUpload#size}.
   */
  public boolean isSizeAvailable() { 
    boolean ret = delegate.isSizeAvailable();
    return ret;
  }

  /**
   * @return the async uploaded file when {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem} has been used
   */
  public io.vertx.mutiny.core.file.AsyncFile file() { 
    io.vertx.mutiny.core.file.AsyncFile ret = io.vertx.mutiny.core.file.AsyncFile.newInstance(delegate.file());
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
    return arg != null ? new HttpServerFileUpload(arg) : null;
  }

}
