package io.vertx.mutiny.core.http;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a client-side WebSocket.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocket.class)
public class WebSocket implements io.vertx.mutiny.core.http.WebSocketBase {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebSocket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebSocket((io.vertx.core.http.WebSocket) obj),
    WebSocket::getDelegate
  );

  private final io.vertx.core.http.WebSocket delegate;
  
  public WebSocket(io.vertx.core.http.WebSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WebSocket() {    this.delegate = null;
  }

  public io.vertx.core.http.WebSocket getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocket that = (WebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.mutiny.core.http.WebSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the status code received when the WebSocket was closed by the other side, otherwise <code>null</code>.
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the reason message received when the WebSocket was closed by the other side, otherwise <code>null</code>.
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePing(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase writePong(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase textMessageHandler(Consumer<String> handler) {
    return __textMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.mutiny.core.http.WebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.mutiny.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __binaryMessageHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.mutiny.core.http.WebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.mutiny.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase binaryMessageHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __binaryMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.http.WebSocketBase __pongHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.http.WebSocketBase pongHandler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pongHandler(handler != null ? handler::accept : null);
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * @return 
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   * @return 
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  private void __close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public Uni<Void> close(short statusCode) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, handler);
    });
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public Void closeAndAwait(short statusCode) { 
    return (Void) close(statusCode).await().indefinitely();
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public Uni<Void> close(short statusCode, String reason) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(statusCode, reason, handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public Void closeAndAwait(short statusCode, String reason) { 
    return (Void) close(statusCode, reason).await().indefinitely();
  }

  /**
   * @return the remote address for this socket
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  private io.vertx.mutiny.core.http.WebSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.http.WebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __write(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  public io.vertx.mutiny.core.http.WebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.http.WebSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeFrame(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFrame(frame, handler);
    });
  }

  public Void writeFrameAndAwait(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    return (Void) writeFrame(frame).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  public Uni<Void> writeFinalTextFrame(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalTextFrame(text, handler);
    });
  }

  public Void writeFinalTextFrameAndAwait(String text) { 
    return (Void) writeFinalTextFrame(text).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeFinalBinaryFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeFinalBinaryFrame(data, handler);
    });
  }

  public Void writeFinalBinaryFrameAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeFinalBinaryFrame(data).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> writeBinaryMessage(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeBinaryMessage(data, handler);
    });
  }

  public Void writeBinaryMessageAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) writeBinaryMessage(data).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  public Uni<Void> writeTextMessage(String text) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __writeTextMessage(text, handler);
    });
  }

  public Void writeTextMessageAndAwait(String text) { 
    return (Void) writeTextMessage(text).await().indefinitely();
  }

  private io.vertx.mutiny.core.http.WebSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.http.WebSocket __frameHandler(Handler<io.vertx.mutiny.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.mutiny.core.http.WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket frameHandler(Consumer<io.vertx.mutiny.core.http.WebSocketFrame> handler) {
    return __frameHandler(handler != null ? handler::accept : null);
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Calls {@link io.vertx.mutiny.core.http.WebSocketBase#close}
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Close the WebSocket sending the default close frame.
   * <p/>
   * No more messages can be sent.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   */
  public void closeAndForget(short statusCode) { 
    delegate.close(statusCode);
  }

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void closeAndForget(short statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  public io.vertx.mutiny.core.http.WebSocket writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFrameAndForget(io.vertx.mutiny.core.http.WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFinalTextFrameAndForget(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeFinalBinaryFrameAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeBinaryMessageAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  public io.vertx.mutiny.core.http.WebSocket writeTextMessageAndForget(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
    return arg != null ? new WebSocket(arg) : null;
  }

}
