package io.vertx.mutiny.core.json.pointer;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 * The JsonPointerIterator is used by the read/write algorithms of the {@link io.vertx.mutiny.core.json.pointer.JsonPointer} to read/write the querying data structure <br/>
 *
 * Every method takes the currentValue as parameter, representing the actual value held by the query algorithm.<br/>
 *
 * Implementations of this interface should be stateless, so they can be reused<br/>
 *
 * You can implement this interface to query the structure you want using json pointers
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.json.pointer.JsonPointerIterator original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.json.pointer.JsonPointerIterator.class)
public class JsonPointerIterator {

  public static final io.smallrye.mutiny.vertx.TypeArg<JsonPointerIterator> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JsonPointerIterator((io.vertx.core.json.pointer.JsonPointerIterator) obj),
    JsonPointerIterator::getDelegate
  );

  private final io.vertx.core.json.pointer.JsonPointerIterator delegate;
  
  public JsonPointerIterator(io.vertx.core.json.pointer.JsonPointerIterator delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  JsonPointerIterator() {    this.delegate = null;
  }

  public io.vertx.core.json.pointer.JsonPointerIterator getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonPointerIterator that = (JsonPointerIterator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is a queryable object
   */
  public boolean isObject(Object currentValue) { 
    boolean ret = delegate.isObject(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is a queryable array
   */
  public boolean isArray(Object currentValue) { 
    boolean ret = delegate.isArray(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @return <code>true</code> if the current value is null/empty
   */
  public boolean isNull(Object currentValue) { 
    boolean ret = delegate.isNull(currentValue);
    return ret;
  }

  /**
   * @param currentValue 
   * @param key object key
   * @return <code>true</code> if current value is a queryable object that contains the specified key
   */
  public boolean objectContainsKey(Object currentValue, String key) { 
    boolean ret = delegate.objectContainsKey(currentValue, key);
    return ret;
  }

  /**
   * Returns the object parameter with specified key.
   * @param currentValue 
   * @param key object key
   * @param createOnMissing If the current value is an object that doesn't contain the key, put an empty object at provided key
   * @return the requested object parameter, or null if the method was not able to find it
   */
  public Object getObjectParameter(Object currentValue, String key, boolean createOnMissing) { 
    Object ret = (Object) delegate.getObjectParameter(currentValue, key, createOnMissing);
    return ret;
  }

  /**
   * Move the iterator the the array element at specified index
   * @param currentValue 
   * @param i array index
   * @return the request array element, or null if the method was not able to find it
   */
  public Object getArrayElement(Object currentValue, int i) { 
    Object ret = (Object) delegate.getArrayElement(currentValue, i);
    return ret;
  }

  /**
   * Write object parameter at specified key
   * @param currentValue 
   * @param key 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean writeObjectParameter(Object currentValue, String key, Object value) { 
    boolean ret = delegate.writeObjectParameter(currentValue, key, value);
    return ret;
  }

  /**
   * Write array element at specified index
   * @param currentValue 
   * @param i 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean writeArrayElement(Object currentValue, int i, Object value) { 
    boolean ret = delegate.writeArrayElement(currentValue, i, value);
    return ret;
  }

  /**
   * Append array element
   * @param currentValue 
   * @param value 
   * @return true if the operation is successful
   */
  public boolean appendArrayElement(Object currentValue, Object value) { 
    boolean ret = delegate.appendArrayElement(currentValue, value);
    return ret;
  }

  /**
   * Instance of a JsonPointerIterator to query Vert.x Json structures
   */
  public static final io.vertx.mutiny.core.json.pointer.JsonPointerIterator JSON_ITERATOR = io.vertx.mutiny.core.json.pointer.JsonPointerIterator.newInstance(io.vertx.core.json.pointer.JsonPointerIterator.JSON_ITERATOR);
  public static  JsonPointerIterator newInstance(io.vertx.core.json.pointer.JsonPointerIterator arg) {
    return arg != null ? new JsonPointerIterator(arg) : null;
  }

}
