package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetClient.class)
public class NetClient implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetClient() {    this.delegate = null;
  }

  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetClient __connect(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetSocket> connect(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __connect(port, host, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(port, host).await().indefinitely();
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetClient __connect(int port, String host, String serverName, Handler<AsyncResult<io.vertx.mutiny.core.net.NetSocket>> connectHandler) { 
    delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetSocket> connect(int port, String host, String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __connect(port, host, serverName, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(int port, String host, String serverName) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(port, host, serverName).await().indefinitely();
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetClient __connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress, Handler<AsyncResult<io.vertx.mutiny.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetSocket> connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __connect(remoteAddress, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(io.vertx.mutiny.core.net.SocketAddress remoteAddress) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(remoteAddress).await().indefinitely();
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetClient __connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName, Handler<AsyncResult<io.vertx.mutiny.core.net.NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetSocket> connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __connect(remoteAddress, serverName, handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(remoteAddress, serverName).await().indefinitely();
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   */
  public void close() { 
    delegate.close();
  }

  public static  NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }

}
