package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  NetServer() {    this.delegate = null;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.mutiny.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  public io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.net.NetSocket> connectStream() { 
    io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.net.NetSocket> ret = io.vertx.mutiny.core.streams.ReadStream.newInstance(delegate.connectStream(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.net.NetSocket.__TYPE_ARG);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.mutiny.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __connectHandler(Handler<io.vertx.mutiny.core.net.NetSocket> handler) { 
    io.vertx.mutiny.core.net.NetServer ret = io.vertx.mutiny.core.net.NetServer.newInstance(delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.mutiny.core.net.NetSocket.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.mutiny.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer connectHandler(Consumer<io.vertx.mutiny.core.net.NetSocket> handler) {
    return __connectHandler(handler != null ? handler::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait() { 
    return (io.vertx.mutiny.core.net.NetServer) listen().await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(int port, String host, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, host, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(port, host).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(int port, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(int port) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(port, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(int port) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(port).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.net.NetServer __listen(io.vertx.mutiny.core.net.SocketAddress localAddress, Handler<AsyncResult<io.vertx.mutiny.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.net.NetServer.newInstance(ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Uni<io.vertx.mutiny.core.net.NetServer> listen(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listen(localAddress, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndAwait(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    return (io.vertx.mutiny.core.net.NetServer) listen(localAddress).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget() { 
    delegate.listen();
    return this;
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * Host <code>0.0.0.0</code> can be specified meaning "listen on all available interfaces".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @param host 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the
   * {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.net.NetServer listenAndForget(io.vertx.mutiny.core.net.SocketAddress localAddress) { 
    delegate.listen(localAddress.getDelegate());
    return this;
  }

  /**
   * Close the server. This will close any currently open connections. The close may not complete until after this
   * method has returned.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  public static  NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
