package io.vertx.mutiny.core.net;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 * The address of a socket, an inet socket address or a domain socket address.
 * <p/>
 * Use {@link io.vertx.mutiny.core.net.SocketAddress#inetSocketAddress} to create an inet socket address and {@link io.vertx.mutiny.core.net.SocketAddress#domainSocketAddress}
 * to create a domain socket address
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.SocketAddress.class)
public class SocketAddress {

  public static final io.smallrye.mutiny.vertx.TypeArg<SocketAddress> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SocketAddress((io.vertx.core.net.SocketAddress) obj),
    SocketAddress::getDelegate
  );

  private final io.vertx.core.net.SocketAddress delegate;
  
  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  SocketAddress() {    this.delegate = null;
  }

  public io.vertx.core.net.SocketAddress getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SocketAddress that = (SocketAddress) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a inet socket address, <code>host</code> must be non <code>null</code> and <code>port</code> must be between <code>0</code>
   * and <code>65536</code>.
   * @param port the address port
   * @param host the address host
   * @return the created socket address
   */
  public static io.vertx.mutiny.core.net.SocketAddress inetSocketAddress(int port, String host) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(io.vertx.core.net.SocketAddress.inetSocketAddress(port, host));
    return ret;
  }

  /**
   * Create a domain socket address.
   * @param path the address path
   * @return the created socket address
   */
  public static io.vertx.mutiny.core.net.SocketAddress domainSocketAddress(String path) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance(io.vertx.core.net.SocketAddress.domainSocketAddress(path));
    return ret;
  }

  /**
   * @return the address host or <code>null</code> for a domain socket
   */
  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  /**
   * @return the address port or <code>-1</code> for a domain socket
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * @return the address path or <code>null</code> for a inet socket
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  public static  SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }

}
