package io.vertx.mutiny.core.parsetools;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A helper class which allows you to easily parse protocols which are delimited by a sequence of bytes, or fixed
 * size records.
 * <p>
 * Instances of this class take as input {@link io.vertx.mutiny.core.buffer.Buffer} instances containing raw bytes,
 * and output records.
 * <p>
 * For example, if I had a simple ASCII text protocol delimited by '\n' and the input was the following:
 * <p>
 * <pre>
 * buffer1:HELLO\nHOW ARE Y
 * buffer2:OU?\nI AM
 * buffer3: DOING OK
 * buffer4:\n
 * </pre>
 * Then the output would be:<p>
 * <pre>
 * buffer1:HELLO
 * buffer2:HOW ARE YOU?
 * buffer3:I AM DOING OK
 * </pre>
 * Instances of this class can be changed between delimited mode and fixed size record mode on the fly as
 * individual records are read, this allows you to parse protocols where, for example, the first 5 records might
 * all be fixed size (of potentially different sizes), followed by some delimited records, followed by more fixed
 * size records.
 * <p>
 * Instances of this class can't currently be used for protocols where the text is encoded with something other than
 * a 1-1 byte-char mapping.
 * <p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.RecordParser original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.parsetools.RecordParser.class)
public class RecordParser implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.core.Handler<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RecordParser> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RecordParser((io.vertx.core.parsetools.RecordParser) obj),
    RecordParser::getDelegate
  );

  private final io.vertx.core.parsetools.RecordParser delegate;
  
  public RecordParser(io.vertx.core.parsetools.RecordParser delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  RecordParser() {    this.delegate = null;
  }

  public io.vertx.core.parsetools.RecordParser getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RecordParser that = (RecordParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), (io.smallrye.mutiny.vertx.TypeArg)io.vertx.mutiny.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  private void __setOutput(Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    delegate.setOutput(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
  }

  public void setOutput(Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    __setOutput(output != null ? output::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter string
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newDelimited(String delim, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter string
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newDelimited(delim, output != null ? output::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter string
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim, Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim, io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in delimited mode, and where the delimiter can be represented
   * by the String <code></code> delim endcoded in latin-1 . Don't use this if your String contains other than latin-1 characters.
   * <p>
   * <code>output</code> Will receive whole records which have been parsed.
   * @param delim the initial delimiter string
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(String delim) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in delimited mode, and where the delimiter can be represented
   * by the <code>Buffer</code> delim.
   * <p>
   * @param delim the initial delimiter buffer
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter buffer
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param delim the initial delimiter buffer
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newDelimited(delim, output != null ? output::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newDelimited} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param delim the initial delimiter buffer
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newDelimited(io.vertx.mutiny.core.buffer.Buffer delim, Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newDelimited(delim.getDelegate(), io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Create a new <code>RecordParser</code> instance, initially in fixed size mode, and where the record size is specified
   * by the <code>size</code> parameter.
   * <p>
   * <code>output</code> Will receive whole records which have been parsed.
   * @param size the initial record size
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newFixed} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param size the initial record size
   * @param output handler that will receive the output
   * @return 
   */
  private static io.vertx.mutiny.core.parsetools.RecordParser __newFixed(int size, Handler<io.vertx.mutiny.core.buffer.Buffer> output) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        output.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    }));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newFixed} but set the <code>output</code> that will receive whole records
   * which have been parsed.
   * @param size the initial record size
   * @param output handler that will receive the output
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, Consumer<io.vertx.mutiny.core.buffer.Buffer> output) {
    return __newFixed(size, output != null ? output::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newFixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, stream.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.parsetools.RecordParser#newFixed} but wraps the <code>stream</code>. The <code>stream</code> handlers will be set/unset
   * when the {@link io.vertx.mutiny.core.parsetools.RecordParser#handler} is set.
   * <p/>
   * The <code>pause()</code>/<code>resume()</code> operations are propagated to the <code>stream</code>.
   * @param size the initial record size
   * @param stream the wrapped stream
   * @return 
   */
  public static io.vertx.mutiny.core.parsetools.RecordParser newFixed(int size, Publisher<io.vertx.mutiny.core.buffer.Buffer> stream) { 
    io.vertx.mutiny.core.parsetools.RecordParser ret = io.vertx.mutiny.core.parsetools.RecordParser.newInstance(io.vertx.core.parsetools.RecordParser.newFixed(size, io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Flip the parser into delimited mode, and where the delimiter can be represented
   * by the String <code>delim</code> encoded in latin-1 . Don't use this if your String contains other than latin-1 characters.
   * <p>
   * This method can be called multiple times with different values of delim while data is being parsed.
   * @param delim the new delimeter
   */
  public void delimitedMode(String delim) { 
    delegate.delimitedMode(delim);
  }

  /**
   * Flip the parser into delimited mode, and where the delimiter can be represented
   * by the delimiter <code>delim</code>.
   * <p>
   * This method can be called multiple times with different values of delim while data is being parsed.
   * @param delim the new delimiter
   */
  public void delimitedMode(io.vertx.mutiny.core.buffer.Buffer delim) { 
    delegate.delimitedMode(delim.getDelegate());
  }

  /**
   * Flip the parser into fixed size mode, where the record size is specified by <code>size</code> in bytes.
   * <p>
   * This method can be called multiple times with different values of size while data is being parsed.
   * @param size the new record size
   */
  public void fixedSizeMode(int size) { 
    delegate.fixedSizeMode(size);
  }

  /**
   * Set the maximum allowed size for a record when using the delimited mode.
   * The delimiter itself does not count for the record size.
   * <p>
   * If a record is longer than specified, an {@link java.lang.IllegalStateException} will be thrown.
   * @param size the maximum record size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.parsetools.RecordParser maxRecordSize(int size) { 
    delegate.maxRecordSize(size);
    return this;
  }

  /**
   * This method is called to provide the parser with data.
   * @param buffer a chunk of data
   */
  public void handle(io.vertx.mutiny.core.buffer.Buffer buffer) { 
    delegate.handle(buffer.getDelegate());
  }

  private io.vertx.mutiny.core.parsetools.RecordParser __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.parsetools.RecordParser __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.mutiny.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser handler(Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.core.parsetools.RecordParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser resume() { 
    delegate.resume();
    return this;
  }

  private io.vertx.mutiny.core.parsetools.RecordParser __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.parsetools.RecordParser endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * Like {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static  RecordParser newInstance(io.vertx.core.parsetools.RecordParser arg) {
    return arg != null ? new RecordParser(arg) : null;
  }

}
