package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.mutiny.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> {

  public static final io.smallrye.mutiny.vertx.TypeArg<AsyncMap> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  AsyncMap() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later with the async result.
   */
  private void __get(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.get(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Uni<V> get(K k) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __get(k, handler);
    });
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public V getAndAwait(K k) { 
    return (V) get(k).await().indefinitely();
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @param completionHandler - this will be called some time later to signify the value has been put
   */
  private void __put(K k, V v, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), completionHandler);
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Uni<Void> put(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __put(k, v, handler);
    });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Void putAndAwait(K k, V v) { 
    return (Void) put(k, v).await().indefinitely();
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  private void __put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, completionHandler);
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Uni<Void> put(K k, V v, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __put(k, v, ttl, handler);
    });
  }

  /**
   * Like {@link io.vertx.mutiny.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Void putAndAwait(K k, V v, long ttl) { 
    return (Void) put(k, v, ttl).await().indefinitely();
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @param completionHandler the handler
   */
  private void __putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Uni<V> putIfAbsent(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __putIfAbsent(k, v, handler);
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return 
   */
  public V putIfAbsentAndAwait(K k, V v) { 
    return (V) putIfAbsent(k, v).await().indefinitely();
  }

  /**
   * Link {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @param completionHandler the handler
   */
  private void __putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) { 
    delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl, new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Link {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public Uni<V> putIfAbsent(K k, V v, long ttl) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __putIfAbsent(k, v, ttl, handler);
    });
  }

  /**
   * Link {@link io.vertx.mutiny.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return 
   */
  public V putIfAbsentAndAwait(K k, V v, long ttl) { 
    return (V) putIfAbsent(k, v, ttl).await().indefinitely();
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  private void __remove(K k, Handler<AsyncResult<V>> resultHandler) { 
    delegate.remove(__typeArg_0.<K>unwrap(k), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public Uni<V> remove(K k) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __remove(k, handler);
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return 
   */
  public V removeAndAwait(K k) { 
    return (V) remove(k).await().indefinitely();
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @param resultHandler - this will be called some time later to signify the value has been removed
   */
  private void __removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), resultHandler);
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Uni<Boolean> removeIfPresent(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __removeIfPresent(k, v, handler);
    });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return 
   */
  public Boolean removeIfPresentAndAwait(K k, V v) { 
    return (Boolean) removeIfPresent(k, v).await().indefinitely();
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param resultHandler the result handler will be passed the previous value
   */
  private void __replace(K k, V v, Handler<AsyncResult<V>> resultHandler) { 
    delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), new Handler<AsyncResult<V>>() {
      public void handle(AsyncResult<V> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((V)__typeArg_1.wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public Uni<V> replace(K k, V v) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __replace(k, v, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return 
   */
  public V replaceAndAwait(K k, V v) { 
    return (V) replace(k, v).await().indefinitely();
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param resultHandler the result handler
   */
  private void __replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), resultHandler);
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public Uni<Boolean> replaceIfPresent(K k, V oldValue, V newValue) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __replaceIfPresent(k, oldValue, newValue, handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return 
   */
  public Boolean replaceIfPresentAndAwait(K k, V oldValue, V newValue) { 
    return (Boolean) replaceIfPresent(k, oldValue, newValue).await().indefinitely();
  }

  /**
   * Clear all entries in the map
   * @param resultHandler called on completion
   */
  private void __clear(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.clear(resultHandler);
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public Uni<Void> clear() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __clear(handler);
    });
  }

  /**
   * Clear all entries in the map
   * @return 
   */
  public Void clearAndAwait() { 
    return (Void) clear().await().indefinitely();
  }

  /**
   * Provide the number of entries in the map
   * @param resultHandler handler which will receive the number of entries
   */
  private void __size(Handler<AsyncResult<Integer>> resultHandler) { 
    delegate.size(resultHandler);
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public Uni<Integer> size() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __size(handler);
    });
  }

  /**
   * Provide the number of entries in the map
   * @return 
   */
  public Integer sizeAndAwait() { 
    return (Integer) size().await().indefinitely();
  }

  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }


  public static <K,V>AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
