package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.Counter.class)
public class Counter {

  public static final io.smallrye.mutiny.vertx.TypeArg<Counter> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Counter() {    this.delegate = null;
  }

  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Get the current value of the counter
   * @param resultHandler handler which will be passed the value
   */
  private void __get(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.get(resultHandler);
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public Uni<Long> get() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __get(handler);
    });
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public Long getAndAwait() { 
    return (Long) get().await().indefinitely();
  }

  /**
   * Increment the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  private void __incrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.incrementAndGet(resultHandler);
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public Uni<Long> incrementAndGet() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __incrementAndGet(handler);
    });
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public Long incrementAndGetAndAwait() { 
    return (Long) incrementAndGet().await().indefinitely();
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @param resultHandler handler which will be passed the value
   */
  private void __getAndIncrement(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndIncrement(resultHandler);
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public Uni<Long> getAndIncrement() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getAndIncrement(handler);
    });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public Long getAndIncrementAndAwait() { 
    return (Long) getAndIncrement().await().indefinitely();
  }

  /**
   * Decrement the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  private void __decrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.decrementAndGet(resultHandler);
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public Uni<Long> decrementAndGet() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __decrementAndGet(handler);
    });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public Long decrementAndGetAndAwait() { 
    return (Long) decrementAndGet().await().indefinitely();
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  private void __addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.addAndGet(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public Uni<Long> addAndGet(long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __addAndGet(value, handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public Long addAndGetAndAwait(long value) { 
    return (Long) addAndGet(value).await().indefinitely();
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  private void __getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndAdd(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public Uni<Long> getAndAdd(long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __getAndAdd(value, handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public Long getAndAddAndAwait(long value) { 
    return (Long) getAndAdd(value).await().indefinitely();
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @param resultHandler the handler will be passed true on success
   */
  private void __compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.compareAndSet(expected, value, resultHandler);
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public Uni<Boolean> compareAndSet(long expected, long value) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __compareAndSet(expected, value, handler);
    });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public Boolean compareAndSetAndAwait(long expected, long value) { 
    return (Boolean) compareAndSet(expected, value).await().indefinitely();
  }

  public static  Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }

}
