package io.vertx.mutiny.core.streams;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;

/**
 * Pumps data from a {@link io.vertx.mutiny.core.streams.ReadStream} to a {@link io.vertx.mutiny.core.streams.WriteStream} and performs flow control where necessary to
 * prevent the write stream buffer from getting overfull.
 * <p>
 * Instances of this class read items from a {@link io.vertx.mutiny.core.streams.ReadStream} and write them to a {@link io.vertx.mutiny.core.streams.WriteStream}. If data
 * can be read faster than it can be written this could result in the write queue of the {@link io.vertx.mutiny.core.streams.WriteStream} growing
 * without bound, eventually causing it to exhaust all available RAM.
 * <p>
 * To prevent this, after each write, instances of this class check whether the write queue of the {@link io.vertx.mutiny.core.streams.WriteStream} is full, and if so, the {@link io.vertx.mutiny.core.streams.ReadStream} is paused, and a <code>drainHandler</code> is set on the
 * {@link io.vertx.mutiny.core.streams.WriteStream}.
 * <p>
 * When the {@link io.vertx.mutiny.core.streams.WriteStream} has processed half of its backlog, the <code>drainHandler</code> will be
 * called, which results in the pump resuming the {@link io.vertx.mutiny.core.streams.ReadStream}.
 * <p>
 * This class can be used to pump from any {@link io.vertx.mutiny.core.streams.ReadStream} to any {@link io.vertx.mutiny.core.streams.WriteStream},
 * e.g. from an {@link io.vertx.mutiny.core.http.HttpServerRequest} to an {@link io.vertx.mutiny.core.file.AsyncFile},
 * or from {@link io.vertx.mutiny.core.net.NetSocket} to a {@link io.vertx.mutiny.core.http.WebSocket}.
 * <p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.Pump original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.streams.Pump.class)
public class Pump {

  public static final io.smallrye.mutiny.vertx.TypeArg<Pump> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Pump((io.vertx.core.streams.Pump) obj),
    Pump::getDelegate
  );

  private final io.vertx.core.streams.Pump delegate;
  
  public Pump(io.vertx.core.streams.Pump delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  Pump() {    this.delegate = null;
  }

  public io.vertx.core.streams.Pump getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pump that = (Pump) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a new <code>Pump</code> with the given <code>ReadStream</code> and <code>WriteStream</code>
   * @param rs the read stream
   * @param ws the write stream
   * @return the pump
   */
  public static <T> io.vertx.mutiny.core.streams.Pump pump(io.vertx.mutiny.core.streams.ReadStream<T> rs, io.vertx.mutiny.core.streams.WriteStream<T> ws) { 
    io.vertx.mutiny.core.streams.Pump ret = io.vertx.mutiny.core.streams.Pump.newInstance(io.vertx.core.streams.Pump.pump(rs.getDelegate(), ws.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>Pump</code> with the given <code>ReadStream</code> and <code>WriteStream</code>
   * @param rs the read stream
   * @param ws the write stream
   * @return the pump
   */
  public static <T> io.vertx.mutiny.core.streams.Pump pump(Publisher<T> rs, io.vertx.mutiny.core.streams.WriteStream<T> ws) { 
    io.vertx.mutiny.core.streams.Pump ret = io.vertx.mutiny.core.streams.Pump.newInstance(io.vertx.core.streams.Pump.pump(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(rs,java.util.function.Function.identity()).resume(), ws.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>Pump</code> with the given <code>ReadStream</code> and <code>WriteStream</code> and
   * <code>writeQueueMaxSize</code>
   * @param rs the read stream
   * @param ws the write stream
   * @param writeQueueMaxSize the max size of the write queue
   * @return the pump
   */
  public static <T> io.vertx.mutiny.core.streams.Pump pump(io.vertx.mutiny.core.streams.ReadStream<T> rs, io.vertx.mutiny.core.streams.WriteStream<T> ws, int writeQueueMaxSize) { 
    io.vertx.mutiny.core.streams.Pump ret = io.vertx.mutiny.core.streams.Pump.newInstance(io.vertx.core.streams.Pump.pump(rs.getDelegate(), ws.getDelegate(), writeQueueMaxSize));
    return ret;
  }

  /**
   * Create a new <code>Pump</code> with the given <code>ReadStream</code> and <code>WriteStream</code> and
   * <code>writeQueueMaxSize</code>
   * @param rs the read stream
   * @param ws the write stream
   * @param writeQueueMaxSize the max size of the write queue
   * @return the pump
   */
  public static <T> io.vertx.mutiny.core.streams.Pump pump(Publisher<T> rs, io.vertx.mutiny.core.streams.WriteStream<T> ws, int writeQueueMaxSize) { 
    io.vertx.mutiny.core.streams.Pump ret = io.vertx.mutiny.core.streams.Pump.newInstance(io.vertx.core.streams.Pump.pump(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(rs,java.util.function.Function.identity()).resume(), ws.getDelegate(), writeQueueMaxSize));
    return ret;
  }

  /**
   * Set the write queue max size to <code>maxSize</code>
   * @param maxSize the max size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.Pump setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * Start the Pump. The Pump can be started and stopped multiple times.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.Pump start() { 
    delegate.start();
    return this;
  }

  /**
   * Stop the Pump. The Pump can be started and stopped multiple times.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.Pump stop() { 
    delegate.stop();
    return this;
  }

  /**
   * Return the total number of items pumped by this pump.
   * @return 
   */
  public int numberPumped() { 
    int ret = delegate.numberPumped();
    return ret;
  }

  public static  Pump newInstance(io.vertx.core.streams.Pump arg) {
    return arg != null ? new Pump(arg) : null;
  }

}
