package io.vertx.mutiny.core.streams;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * Represents a stream of data that can be written to.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.mutiny.core.streams.Pipe} to pipe data from a <code>ReadStream</code>
 * to it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.WriteStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.streams.WriteStream.class)
public interface WriteStream<T> extends io.vertx.mutiny.core.streams.StreamBase {

  io.vertx.core.streams.WriteStream getDelegate();

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> exceptionHandler(Consumer<Throwable> handler);
  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Uni<Void> write(T data);
  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Void writeAndAwait(T data);
  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Uni<Void> end();
  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Void endAndAwait();
  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Uni<Void> end(T data);
  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Void endAndAwait(T data);
  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * <code>Pump</code> to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.mutiny.core.net.NetSocket}, the number of {@link io.vertx.mutiny.core.eventbus.Message} for a
   * {@link io.vertx.mutiny.core.eventbus.MessageProducer}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize);
  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.mutiny.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull();
  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.mutiny.core.streams.Pump} for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> drainHandler(Consumer<Void> handler);
  public static <T>WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg) {
    return arg != null ? new WriteStreamImpl<T>(arg) : null;
  }


  public static <T>WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new WriteStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class WriteStreamImpl<T> implements WriteStream<T> {
  private final io.vertx.core.streams.WriteStream<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public io.vertx.core.streams.WriteStream getDelegate() {
    return delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WriteStreamImpl() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.streams.WriteStream<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  private io.vertx.mutiny.core.streams.WriteStream<T> __write(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
    return this;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Uni<Void> write(T data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Void writeAndAwait(T data) { 
    return (Void) write(data).await().indefinitely();
  }

  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  private void __end(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Uni<Void> end(T data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Void endAndAwait(T data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * <code>Pump</code> to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.mutiny.core.net.NetSocket}, the number of {@link io.vertx.mutiny.core.eventbus.Message} for a
   * {@link io.vertx.mutiny.core.eventbus.MessageProducer}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.mutiny.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.mutiny.core.streams.Pump} for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.mutiny.core.streams.WriteStream<T> __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.mutiny.core.streams.Pump} for an example of this being used.
   * <p/>
   * The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * Write some data to the stream. The data is put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.mutiny.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if using a {@link io.vertx.mutiny.core.streams.Pump}.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.core.streams.WriteStream<T> writeAndForget(T data) { 
    delegate.write(__typeArg_0.<T>unwrap(data));
    return this;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Same as {@link io.vertx.mutiny.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void endAndForget(T data) { 
    delegate.end(__typeArg_0.<T>unwrap(data));
  }

}
