package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Represents the writable side of an action that may, or may not, have occurred yet.
 * <p>
 * The {@link io.vertx.mutiny.core.Promise#future} method returns the {@link io.vertx.core.Future} associated with a promise, the future
 * can be used for getting notified of the promise completion and retrieve its value.
 * <p>
 * A promise extends <code>Handler<AsyncResult<T>></code> so it can be used as a callback.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Promise original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.Promise.class)
public class Promise<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<Promise> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Promise((io.vertx.core.Promise) obj),
    Promise::getDelegate
  );

  private final io.vertx.core.Promise<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Promise(io.vertx.core.Promise delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Promise(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.Promise)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public Promise(io.vertx.core.Promise delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Promise() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.Promise getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Promise that = (Promise) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the promise
   */
  public static <T> io.vertx.mutiny.core.Promise<T> promise() { 
    io.vertx.mutiny.core.Promise<T> ret = io.vertx.mutiny.core.Promise.newInstance((io.vertx.core.Promise)io.vertx.core.Promise.promise(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param result the result
   */
  public void complete(T result) { 
    delegate.complete(__typeArg_0.<T>unwrap(result));
  }

  /**
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * @param cause the failure cause
   */
  public void fail(java.lang.Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * @param message the failure message
   */
  public void fail(String message) { 
    delegate.fail(message);
  }

  /**
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.<T>unwrap(result));
    return ret;
  }

  /**
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * @param cause the failure cause
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryFail(java.lang.Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * @param message the failure message
   * @return false when the future is already completed
   */
  public boolean tryFail(String message) { 
    boolean ret = delegate.tryFail(message);
    return ret;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<T> future() { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.future());}

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.Promise#future}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the T instance produced by the operation.
   */
  public T futureAndAwait() { 
    return future().await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.core.Promise#future} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.Promise#future}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.Promise#future} but you don't need to compose it with other operations.
   */
  public void futureAndForget() { 
    future().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }


  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg) {
    return arg != null ? new Promise<T>(arg) : null;
  }


  public static <T>Promise<T> newInstance(io.vertx.core.Promise arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Promise<T>(arg, __typeArg_T) : null;
  }

}
