package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.Future;
import java.util.function.Function;
import java.util.List;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous HTTP client.
 * <p>
 * It allows you to make requests to HTTP servers, and a single client can make requests to any server.
 * <p>
 * It also allows you to open WebSockets to servers.
 * <p>
 * The client can also pool HTTP connections.
 * <p>
 * For pooling to occur, keep-alive must be true on the {@link io.vertx.core.http.HttpClientOptions} (default is true).
 * In this case connections will be pooled and re-used if there are pending HTTP requests waiting to get a connection,
 * otherwise they will be closed.
 * <p>
 * This gives the benefits of keep alive when the client is loaded but means we don't keep connections hanging around
 * unnecessarily when there would be no benefits anyway.
 * <p>
 * The client also supports pipe-lining of requests. Pipe-lining means another request is sent on the same connection
 * before the response from the preceding one has returned. Pipe-lining is not appropriate for all requests.
 * <p>
 * To enable pipe-lining, it must be enabled on the {@link io.vertx.core.http.HttpClientOptions} (default is false).
 * <p>
 * When pipe-lining is enabled the connection will be automatically closed when all in-flight responses have returned
 * and there are no outstanding pending requests to write.
 * <p>
 * The client is designed to be reused between requests.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpClient.class)
public class HttpClient implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpClient((io.vertx.core.http.HttpClient) obj),
    HttpClient::getDelegate
  );

  private final io.vertx.core.http.HttpClient delegate;
  
  public HttpClient(io.vertx.core.http.HttpClient delegate) {
    this.delegate = delegate;
  }

  public HttpClient(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpClient() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClient that = (HttpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Create an HTTP request to send to the server. The <code>handler</code>
   * is called when the request is ready to be sent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the request options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClientRequest> request(io.vertx.core.http.RequestOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.request(options, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#request(RequestOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the request options
   * @return the HttpClientRequest instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAndAwait(io.vertx.core.http.RequestOptions options) { 
    return (io.vertx.mutiny.core.http.HttpClientRequest) request(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#request(RequestOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#request(RequestOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#request(RequestOptions)} but you don't need to compose it with other operations.
   * @param options the request options
   */
  public void requestAndForget(io.vertx.core.http.RequestOptions options) { 
    request(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and <code>port</code>. The <code>handler</code>
   * is called when the request is ready to be sent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, int port, String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.request(method, port, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the HttpClientRequest instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAndAwait(io.vertx.core.http.HttpMethod method, int port, String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.HttpClientRequest) request(method, port, host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,int,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,int,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,int,String,String)} but you don't need to compose it with other operations.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   */
  public void requestAndForget(io.vertx.core.http.HttpMethod method, int port, String host, String requestURI) { 
    request(method, port, host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and default port. The <code>handler</code>
   * is called when the request is ready to be sent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.request(method, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return the HttpClientRequest instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAndAwait(io.vertx.core.http.HttpMethod method, String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.HttpClientRequest) request(method, host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String,String)} but you don't need to compose it with other operations.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   */
  public void requestAndForget(io.vertx.core.http.HttpMethod method, String host, String requestURI) { 
    request(method, host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Create an HTTP request to send to the server at the default host and port. The <code>handler</code>
   * is called when the request is ready to be sent.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.request(method, requestURI, new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return the HttpClientRequest instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpClientRequest requestAndAwait(io.vertx.core.http.HttpMethod method, String requestURI) { 
    return (io.vertx.mutiny.core.http.HttpClientRequest) request(method, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#request(HttpMethod,String)} but you don't need to compose it with other operations.
   * @param method the HTTP method
   * @param requestURI the relative URI
   */
  public void requestAndForget(io.vertx.core.http.HttpMethod method, String requestURI) { 
    request(method, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(int port, String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.webSocket(port, host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(int port, String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(port, host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(int,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(int,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#webSocket(int,String,String)} but you don't need to compose it with other operations.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   */
  public void webSocketAndForget(int port, String host, String requestURI) { 
    webSocket(port, host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket to the host and relative request URI and default port
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param host the host
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(String host, String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.webSocket(host, requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param host the host
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(String host, String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(host, requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String,String)} but you don't need to compose it with other operations.
   * @param host the host
   * @param requestURI the relative URI
   */
  public void webSocketAndForget(String host, String requestURI) { 
    webSocket(host, requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket at the relative request URI using the default host and port
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param requestURI the relative URI
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(String requestURI) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.webSocket(requestURI, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param requestURI the relative URI
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(String requestURI) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(requestURI).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#webSocket(String)} but you don't need to compose it with other operations.
   * @param requestURI the relative URI
   */
  public void webSocketAndForget(String requestURI) { 
    webSocket(requestURI).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket with the specified options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the request options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> webSocket(io.vertx.core.http.WebSocketConnectOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.webSocket(options, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(WebSocketConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the request options
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAndAwait(io.vertx.core.http.WebSocketConnectOptions options) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocket(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(WebSocketConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#webSocket(WebSocketConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#webSocket(WebSocketConnectOptions)} but you don't need to compose it with other operations.
   * @param options the request options
   */
  public void webSocketAndForget(io.vertx.core.http.WebSocketConnectOptions options) { 
    webSocket(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Connect a WebSocket with the specified absolute url, with the specified headers, using
   * the specified version of WebSockets, and the specified WebSocket sub protocols.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.WebSocket> webSocketAbs(String url, io.vertx.mutiny.core.MultiMap headers, io.vertx.core.http.WebsocketVersion version, List<String> subProtocols) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, new Handler<AsyncResult<io.vertx.core.http.WebSocket>>() {
      public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocketAbs(String,io.vertx.mutiny.core.MultiMap,WebsocketVersion,List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   * @return the WebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.WebSocket webSocketAbsAndAwait(String url, io.vertx.mutiny.core.MultiMap headers, io.vertx.core.http.WebsocketVersion version, List<String> subProtocols) { 
    return (io.vertx.mutiny.core.http.WebSocket) webSocketAbs(url, headers, version, subProtocols).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#webSocketAbs(String,io.vertx.mutiny.core.MultiMap,WebsocketVersion,List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#webSocketAbs(String,io.vertx.mutiny.core.MultiMap,WebsocketVersion,List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#webSocketAbs(String,io.vertx.mutiny.core.MultiMap,WebsocketVersion,List<String>)} but you don't need to compose it with other operations.
   * @param url the absolute url
   * @param headers the headers
   * @param version the WebSocket version
   * @param subProtocols the subprotocols to use
   */
  public void webSocketAbsAndForget(String url, io.vertx.mutiny.core.MultiMap headers, io.vertx.core.http.WebsocketVersion version, List<String> subProtocols) { 
    webSocketAbs(url, headers, version, subProtocols).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpClient __connectionHandler(Handler<io.vertx.mutiny.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.mutiny.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClient connectionHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.HttpConnection> handler) {
    return __connectionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler the new redirect handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpClient redirectHandler(Function<io.vertx.mutiny.core.http.HttpClientResponse, io.smallrye.mutiny.Uni<io.vertx.core.http.RequestOptions>> handler) { 
    delegate.redirectHandler(new java.util.function.Function<io.vertx.core.http.HttpClientResponse,io.vertx.core.Future<io.vertx.core.http.RequestOptions>>() {
      public io.vertx.core.Future<io.vertx.core.http.RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 handler.apply(io.vertx.mutiny.core.http.HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)arg))
            );
         }
     });
    return this;
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
    return arg != null ? new HttpClient(arg) : null;
  }

}
