package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.WebSocketFrameType;

/**
 * A WebSocket frame that represents either text or binary data.
 * <p>
 * A WebSocket message is composed of one or more WebSocket frames.
 * <p>
 * If there is a just a single frame in the message then a single text or binary frame should be created with final = true.
 * <p>
 * If there are more than one frames in the message, then the first frame should be a text or binary frame with
 * final = false, followed by one or more continuation frames. The last continuation frame should have final = true.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketFrame original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.WebSocketFrame.class)
public class WebSocketFrame {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebSocketFrame> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebSocketFrame((io.vertx.core.http.WebSocketFrame) obj),
    WebSocketFrame::getDelegate
  );

  private final io.vertx.core.http.WebSocketFrame delegate;
  
  public WebSocketFrame(io.vertx.core.http.WebSocketFrame delegate) {
    this.delegate = delegate;
  }

  public WebSocketFrame(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketFrame)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WebSocketFrame() {
    this.delegate = null;
  }

  public io.vertx.core.http.WebSocketFrame getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketFrame that = (WebSocketFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.mutiny.core.http.WebSocketFrame binaryFrame(io.vertx.mutiny.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.mutiny.core.http.WebSocketFrame ret = io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.binaryFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * @param str the string for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.mutiny.core.http.WebSocketFrame textFrame(String str, boolean isFinal) { 
    io.vertx.mutiny.core.http.WebSocketFrame ret = io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.textFrame(str, isFinal));
    return ret;
  }

  /**
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.mutiny.core.http.WebSocketFrame pingFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    io.vertx.mutiny.core.http.WebSocketFrame ret = io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.pingFrame(data.getDelegate()));
    return ret;
  }

  /**
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.mutiny.core.http.WebSocketFrame pongFrame(io.vertx.mutiny.core.buffer.Buffer data) { 
    io.vertx.mutiny.core.http.WebSocketFrame ret = io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.pongFrame(data.getDelegate()));
    return ret;
  }

  /**
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.mutiny.core.http.WebSocketFrame continuationFrame(io.vertx.mutiny.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.mutiny.core.http.WebSocketFrame ret = io.vertx.mutiny.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.continuationFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * @return the frame type
   */
  public io.vertx.core.http.WebSocketFrameType type() { 
    io.vertx.core.http.WebSocketFrameType ret = delegate.type();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isBinary() { 
    boolean ret = delegate.isBinary();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isContinuation() { 
    boolean ret = delegate.isContinuation();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isClose() { 
    boolean ret = delegate.isClose();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isPing() { 
    boolean ret = delegate.isPing();
    return ret;
  }

  /**
   * @return the content of this frame as a UTF-8 string and returns the converted string. Only use this for text frames.
   */
  public String textData() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.textData();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the data of the frame
   */
  public io.vertx.mutiny.core.buffer.Buffer binaryData() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.binaryData());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this is the final frame.
   */
  public boolean isFinal() { 
    boolean ret = delegate.isFinal();
    return ret;
  }

  /**
   * @return status code of close frame. Only use this for close frames
   */
  public short closeStatusCode() { 
    short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return string explaining close reason. Only use this for close frames
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  private String cached_0;
  private io.vertx.mutiny.core.buffer.Buffer cached_1;
  public static  WebSocketFrame newInstance(io.vertx.core.http.WebSocketFrame arg) {
    return arg != null ? new WebSocketFrame(arg) : null;
  }

}
