package io.vertx.mutiny.kafka.admin;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.kafka.admin.NewTopic;
import java.util.Set;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.List;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.ClusterDescription;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka Admin client implementation
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.admin.KafkaAdminClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaAdminClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient) obj),
    KafkaAdminClient::getDelegate
  );

  private final io.vertx.kafka.admin.KafkaAdminClient delegate;
  
  public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  KafkaAdminClient() {    this.delegate = null;
  }

  public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaAdminClient that = (KafkaAdminClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka admin client configuration
   * @return an instance of the KafkaAdminClient
   */
  public static io.vertx.mutiny.kafka.admin.KafkaAdminClient create(io.vertx.mutiny.core.Vertx vertx, Map<String, String> config) { 
    io.vertx.mutiny.kafka.admin.KafkaAdminClient ret = io.vertx.mutiny.kafka.admin.KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param completionHandler handler called on operation completed with the topics set
   */
  private void __listTopics(Handler<AsyncResult<Set<String>>> completionHandler) { 
    delegate.listTopics(completionHandler);
  }

  /**
   * List the topics available in the cluster with the default options.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Set<String>> listTopics() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listTopics(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listTopics}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<String> instance produced by the operation
   */
  public Set<String> listTopicsAndAwait() { 
    return (Set<String>) listTopics().await().indefinitely();
  }

  /**
   * @param topics topics to create
   * @param completionHandler handler called on operation completed
   */
  private void __createTopics(List<NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.createTopics(topics, completionHandler);
  }

  /**
   * Creates a batch of new Kafka topics
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics topics to create
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> createTopics(List<NewTopic> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __createTopics(topics, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#createTopics(List<NewTopic>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics topics to create
   * @return the Void instance produced by the operation
   */
  public Void createTopicsAndAwait(List<NewTopic> topics) { 
    return (Void) createTopics(topics).await().indefinitely();
  }

  /**
   * @param topicNames the names of the topics to delete
   * @param completionHandler handler called on operation completed
   */
  private void __deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteTopics(topicNames, completionHandler);
  }

  /**
   * Deletes a batch of Kafka topics
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicNames the names of the topics to delete
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> deleteTopics(List<String> topicNames) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deleteTopics(topicNames, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteTopics(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicNames the names of the topics to delete
   * @return the Void instance produced by the operation
   */
  public Void deleteTopicsAndAwait(List<String> topicNames) { 
    return (Void) deleteTopics(topicNames).await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed with the consumer groups ids
   */
  private void __listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> completionHandler) { 
    delegate.listConsumerGroups(completionHandler);
  }

  /**
   * Get the the consumer groups available in the cluster with the default options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<List<ConsumerGroupListing>> listConsumerGroups() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __listConsumerGroups(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#listConsumerGroups}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the List<ConsumerGroupListing> instance produced by the operation
   */
  public List<ConsumerGroupListing> listConsumerGroupsAndAwait() { 
    return (List<ConsumerGroupListing>) listConsumerGroups().await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed with the cluster description
   */
  private void __describeCluster(Handler<AsyncResult<ClusterDescription>> completionHandler) { 
    delegate.describeCluster(completionHandler);
  }

  /**
   * Describe the nodes in the cluster with the default options
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<ClusterDescription> describeCluster() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __describeCluster(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#describeCluster}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ClusterDescription instance produced by the operation
   */
  public ClusterDescription describeClusterAndAwait() { 
    return (ClusterDescription) describeCluster().await().indefinitely();
  }

  /**
   * @param groupIds the ids of the groups to delete
   * @param completionHandler handler called on operation completed
   */
  private void __deleteConsumerGroups(List<String> groupIds, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteConsumerGroups(groupIds, completionHandler);
  }

  /**
   * Delete consumer groups from the cluster.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param groupIds the ids of the groups to delete
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> deleteConsumerGroups(List<String> groupIds) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deleteConsumerGroups(groupIds, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroups(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param groupIds the ids of the groups to delete
   * @return the Void instance produced by the operation
   */
  public Void deleteConsumerGroupsAndAwait(List<String> groupIds) { 
    return (Void) deleteConsumerGroups(groupIds).await().indefinitely();
  }

  /**
   * @param groupId The group id of the group whose offsets will be listed
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   * @param completionHandler 
   */
  private void __deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.deleteConsumerGroupOffsets(groupId, partitions, completionHandler);
  }

  /**
   * Delete committed offsets for a set of partitions in a consumer group. This will
   * succeed at the partition level only if the group is not actively subscribed
   * to the corresponding topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param groupId The group id of the group whose offsets will be listed
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __deleteConsumerGroupOffsets(groupId, partitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#deleteConsumerGroupOffsets(String,Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param groupId The group id of the group whose offsets will be listed
   * @param partitions The set of partitions in the consumer group whose offsets will be deleted
   * @return the Void instance produced by the operation
   */
  public Void deleteConsumerGroupOffsetsAndAwait(String groupId, Set<TopicPartition> partitions) { 
    return (Void) deleteConsumerGroupOffsets(groupId, partitions).await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the admin client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  private void __close(long timeout, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

  /**
   * Close the admin client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout timeout to wait for closing
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout timeout to wait for closing
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(long timeout) { 
    return (Void) close(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.admin.KafkaAdminClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  public static  KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
    return arg != null ? new KafkaAdminClient(arg) : null;
  }

}
