package io.vertx.mutiny.kafka.client.consumer;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.Set;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.List;
import java.util.Map;
import java.time.Duration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.kafka.client.consumer.OffsetAndTimestamp;

/**
 * Vert.x Kafka consumer.
 * <p>
 * You receive Kafka records by providing a {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#handler}. As messages arrive the handler
 * will be called with the records.
 * <p>
 * The {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume} provides global control over reading the records from the consumer.
 * <p>
 * The {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume} provides finer grained control over reading records
 * for specific Topic/Partition, these are Kafka's specific operations.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K,V> implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaConsumer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer) obj),
    KafkaConsumer::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumer<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  KafkaConsumer() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumer that = (KafkaConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> ret = io.vertx.mutiny.core.streams.Pipe.newInstance(delegate.pipe(), new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K,V>>(o0 -> io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)o0, __typeArg_0, __typeArg_1), o0 -> o0.getDelegate()));
    return ret;
  }

  private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pipeTo(dst, handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance(io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __handler(Handler<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> handler) { 
    delegate.handler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V> event) {
        handler.handle(io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord.newInstance(event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> handler(Consumer<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resume() { 
    delegate.resume();
    return this;
  }

  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @return current demand
   */
  public long demand() { 
    long ret = delegate.demand();
    return ret;
  }

  /**
   * @param topic topic to subscribe to
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __subscribe(String topic, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.subscribe(topic, completionHandler);
    return this;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public Uni<Void> subscribe(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __subscribe(topic, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public Void subscribeAndAwait(String topic) { 
    return (Void) subscribe(topic).await().indefinitely();
  }

  /**
   * @param topics topics to subscribe to
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __subscribe(Set<String> topics, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.subscribe(topics, completionHandler);
    return this;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public Uni<Void> subscribe(Set<String> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __subscribe(topics, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public Void subscribeAndAwait(Set<String> topics) { 
    return (Void) subscribe(topics).await().indefinitely();
  }

  /**
   * @param topicPartition partition which want assigned
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __assign(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.assign(topicPartition, completionHandler);
    return this;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public Uni<Void> assign(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __assign(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public Void assignAndAwait(TopicPartition topicPartition) { 
    return (Void) assign(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartitions partitions which want assigned
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __assign(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.assign(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public Uni<Void> assign(Set<TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __assign(topicPartitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public Void assignAndAwait(Set<TopicPartition> topicPartitions) { 
    return (Void) assign(topicPartitions).await().indefinitely();
  }

  /**
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __assignment(Handler<AsyncResult<Set<TopicPartition>>> handler) { 
    delegate.assignment(handler);
    return this;
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return current KafkaConsumer instance
   */
  public Uni<Set<TopicPartition>> assignment() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __assignment(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assignment}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return current KafkaConsumer instance
   */
  public Set<TopicPartition> assignmentAndAwait() { 
    return (Set<TopicPartition>) assignment().await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __unsubscribe(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.unsubscribe(completionHandler);
    return this;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return current KafkaConsumer instance
   */
  public Uni<Void> unsubscribe() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __unsubscribe(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return current KafkaConsumer instance
   */
  public Void unsubscribeAndAwait() { 
    return (Void) unsubscribe().await().indefinitely();
  }

  /**
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __subscription(Handler<AsyncResult<Set<String>>> handler) { 
    delegate.subscription(handler);
    return this;
  }

  /**
   * Get the current subscription.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return current KafkaConsumer instance
   */
  public Uni<Set<String>> subscription() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __subscription(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscription}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return current KafkaConsumer instance
   */
  public Set<String> subscriptionAndAwait() { 
    return (Set<String>) subscription().await().indefinitely();
  }

  /**
   * @param topicPartition topic partition from which suspend fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __pause(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.pause(topicPartition, completionHandler);
    return this;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public Uni<Void> pause(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pause(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public Void pauseAndAwait(TopicPartition topicPartition) { 
    return (Void) pause(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartitions topic partition from which suspend fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __pause(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.pause(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public Uni<Void> pause(Set<TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __pause(topicPartitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public Void pauseAndAwait(Set<TopicPartition> topicPartitions) { 
    return (Void) pause(topicPartitions).await().indefinitely();
  }

  /**
   * @param handler handler called on operation completed
   */
  private void __paused(Handler<AsyncResult<Set<TopicPartition>>> handler) { 
    delegate.paused(handler);
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Set<TopicPartition>> paused() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __paused(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#paused}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<TopicPartition> instance produced by the operation
   */
  public Set<TopicPartition> pausedAndAwait() { 
    return (Set<TopicPartition>) paused().await().indefinitely();
  }

  /**
   * @param topicPartition topic partition from which resume fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __resume(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.resume(topicPartition, completionHandler);
    return this;
  }

  /**
   * Resume specified partition which have been paused with pause.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public Uni<Void> resume(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resume(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public Void resumeAndAwait(TopicPartition topicPartition) { 
    return (Void) resume(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartitions topic partition from which resume fetching
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __resume(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.resume(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public Uni<Void> resume(Set<TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __resume(topicPartitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public Void resumeAndAwait(Set<TopicPartition> topicPartitions) { 
    return (Void) resume(topicPartitions).await().indefinitely();
  }

  /**
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __partitionsRevokedHandler(Handler<Set<TopicPartition>> handler) { 
    delegate.partitionsRevokedHandler(handler);
    return this;
  }

  /**
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> partitionsRevokedHandler(Consumer<Set<TopicPartition>> handler) {
    return __partitionsRevokedHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __partitionsAssignedHandler(Handler<Set<TopicPartition>> handler) { 
    delegate.partitionsAssignedHandler(handler);
    return this;
  }

  /**
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> partitionsAssignedHandler(Consumer<Set<TopicPartition>> handler) {
    return __partitionsAssignedHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __seek(TopicPartition topicPartition, long offset, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seek(topicPartition, offset, completionHandler);
    return this;
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public Uni<Void> seek(TopicPartition topicPartition, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __seek(topicPartition, offset, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public Void seekAndAwait(TopicPartition topicPartition, long offset) { 
    return (Void) seek(topicPartition, offset).await().indefinitely();
  }

  /**
   * @param topicPartition topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __seekToBeginning(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToBeginning(topicPartition, completionHandler);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Uni<Void> seekToBeginning(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __seekToBeginning(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Void seekToBeginningAndAwait(TopicPartition topicPartition) { 
    return (Void) seekToBeginning(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartitions topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __seekToBeginning(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToBeginning(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Uni<Void> seekToBeginning(Set<TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __seekToBeginning(topicPartitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Void seekToBeginningAndAwait(Set<TopicPartition> topicPartitions) { 
    return (Void) seekToBeginning(topicPartitions).await().indefinitely();
  }

  /**
   * @param topicPartition topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __seekToEnd(TopicPartition topicPartition, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToEnd(topicPartition, completionHandler);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Uni<Void> seekToEnd(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __seekToEnd(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Void seekToEndAndAwait(TopicPartition topicPartition) { 
    return (Void) seekToEnd(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartitions topic partition for which seek
   * @param completionHandler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __seekToEnd(Set<TopicPartition> topicPartitions, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.seekToEnd(topicPartitions, completionHandler);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Uni<Void> seekToEnd(Set<TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __seekToEnd(topicPartitions, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set<TopicPartition>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public Void seekToEndAndAwait(Set<TopicPartition> topicPartitions) { 
    return (Void) seekToEnd(topicPartitions).await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed
   */
  private void __commit(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.commit(completionHandler);
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> commit() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __commit(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void commitAndAwait() { 
    return (Void) commit().await().indefinitely();
  }

  /**
   * @param topicPartition topic partition for getting last committed offset
   * @param handler handler called on operation completed
   */
  private void __committed(TopicPartition topicPartition, Handler<AsyncResult<OffsetAndMetadata>> handler) { 
    delegate.committed(topicPartition, handler);
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for getting last committed offset
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<OffsetAndMetadata> committed(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __committed(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#committed(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for getting last committed offset
   * @return the OffsetAndMetadata instance produced by the operation
   */
  public OffsetAndMetadata committedAndAwait(TopicPartition topicPartition) { 
    return (OffsetAndMetadata) committed(topicPartition).await().indefinitely();
  }

  /**
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get metadata about the partitions for a given topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaConsumer instance
   */
  public Uni<List<PartitionInfo>> partitionsFor(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __partitionsFor(topic, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#partitionsFor(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic partition for which getting partitions info
   * @return current KafkaConsumer instance
   */
  public List<PartitionInfo> partitionsForAndAwait(String topic) { 
    return (List<PartitionInfo>) partitionsFor(topic).await().indefinitely();
  }

  /**
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __batchHandler(Handler<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> handler) { 
    delegate.batchHandler(new Handler<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>() {
      public void handle(io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V> event) {
        handler.handle(io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords.newInstance(event, __typeArg_0, __typeArg_1));
      }
    });
    return this;
  }

  /**
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> batchHandler(Consumer<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> handler) {
    return __batchHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param completionHandler handler called on operation completed
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the consumer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param partition The partition to get the position for
   * @param handler handler called on operation completed
   */
  private void __position(TopicPartition partition, Handler<AsyncResult<Long>> handler) { 
    delegate.position(partition, handler);
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param partition The partition to get the position for
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Long> position(TopicPartition partition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __position(partition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#position(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param partition The partition to get the position for
   * @return the Long instance produced by the operation
   */
  public Long positionAndAwait(TopicPartition partition) { 
    return (Long) position(partition).await().indefinitely();
  }

  /**
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @param handler handler called on operation completed
   */
  private void __offsetsForTimes(TopicPartition topicPartition, Long timestamp, Handler<AsyncResult<OffsetAndTimestamp>> handler) { 
    delegate.offsetsForTimes(topicPartition, timestamp, handler);
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<OffsetAndTimestamp> offsetsForTimes(TopicPartition topicPartition, Long timestamp) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __offsetsForTimes(topicPartition, timestamp, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#offsetsForTimes(TopicPartition,Long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return the OffsetAndTimestamp instance produced by the operation
   */
  public OffsetAndTimestamp offsetsForTimesAndAwait(TopicPartition topicPartition, Long timestamp) { 
    return (OffsetAndTimestamp) offsetsForTimes(topicPartition, timestamp).await().indefinitely();
  }

  /**
   * @param topicPartition the partition to get the earliest offset.
   * @param handler handler called on operation completed. Returns the earliest available offset for the given partition
   */
  private void __beginningOffsets(TopicPartition topicPartition, Handler<AsyncResult<Long>> handler) { 
    delegate.beginningOffsets(topicPartition, handler);
  }

  /**
   * Get the first offset for the given partitions.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition the partition to get the earliest offset.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Long> beginningOffsets(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __beginningOffsets(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#beginningOffsets(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition the partition to get the earliest offset.
   * @return the Long instance produced by the operation
   */
  public Long beginningOffsetsAndAwait(TopicPartition topicPartition) { 
    return (Long) beginningOffsets(topicPartition).await().indefinitely();
  }

  /**
   * @param topicPartition the partition to get the end offset.
   * @param handler handler called on operation completed. The end offset for the given partition.
   */
  private void __endOffsets(TopicPartition topicPartition, Handler<AsyncResult<Long>> handler) { 
    delegate.endOffsets(topicPartition, handler);
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition the partition to get the end offset.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Long> endOffsets(TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __endOffsets(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#endOffsets(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition the partition to get the end offset.
   * @return the Long instance produced by the operation
   */
  public Long endOffsetsAndAwait(TopicPartition topicPartition) { 
    return (Long) endOffsets(topicPartition).await().indefinitely();
  }

  /**
   * @param timeout 
   * @return 
   */
  @Deprecated
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pollTimeout(long timeout) { 
    delegate.pollTimeout(timeout);
    return this;
  }

  /**
   * @param timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @param handler handler called after the poll with batch of records (can be empty).
   */
  @Deprecated
  private void __poll(long timeout, Handler<AsyncResult<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>>> handler) { 
    delegate.poll(timeout, new Handler<AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>>() {
      public void handle(AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords.newInstance(ar.result(), __typeArg_0, __typeArg_1)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Executes a poll for getting messages from Kafka
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @Deprecated
  public Uni<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> poll(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __poll(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return the KafkaConsumerRecords<K,V> instance produced by the operation
   */
  @Deprecated
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V> pollAndAwait(long timeout) { 
    return (io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>) poll(timeout).await().indefinitely();
  }

  /**
   * @param timeout The time, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return 
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pollTimeout(Duration timeout) { 
    delegate.pollTimeout(timeout);
    return this;
  }

  /**
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @param handler handler called after the poll with batch of records (can be empty).
   */
  private void __poll(Duration timeout, Handler<AsyncResult<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>>> handler) { 
    delegate.poll(timeout, new Handler<AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>>>() {
      public void handle(AsyncResult<io.vertx.kafka.client.consumer.KafkaConsumerRecords<K,V>> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords.newInstance(ar.result(), __typeArg_0, __typeArg_1)));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> poll(Duration timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __poll(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(Duration)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return the KafkaConsumerRecords<K,V> instance produced by the operation
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V> pollAndAwait(Duration timeout) { 
    return (io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>) poll(timeout).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)} but you don't need to compose it with other operations.
   * @param topic topic to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> subscribeAndForget(String topic) { 
    delegate.subscribe(topic);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set<String>)} but you don't need to compose it with other operations.
   * @param topics topics to subscribe to
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> subscribeAndForget(Set<String> topics) { 
    delegate.subscribe(topics);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition partition which want assigned
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> assignAndForget(TopicPartition topicPartition) { 
    delegate.assign(topicPartition);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set<TopicPartition>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set<TopicPartition>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set<TopicPartition>)} but you don't need to compose it with other operations.
   * @param topicPartitions partitions which want assigned
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> assignAndForget(Set<TopicPartition> topicPartitions) { 
    delegate.assign(topicPartitions);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe} but you don't need to compose it with other operations.
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> unsubscribeAndForget() { 
    delegate.unsubscribe();
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pauseAndForget(TopicPartition topicPartition) { 
    delegate.pause(topicPartition);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set<TopicPartition>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set<TopicPartition>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set<TopicPartition>)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition from which suspend fetching
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pauseAndForget(Set<TopicPartition> topicPartitions) { 
    delegate.pause(topicPartitions);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resumeAndForget(TopicPartition topicPartition) { 
    delegate.resume(topicPartition);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set<TopicPartition>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set<TopicPartition>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set<TopicPartition>)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition from which resume fetching
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resumeAndForget(Set<TopicPartition> topicPartitions) { 
    delegate.resume(topicPartitions);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekAndForget(TopicPartition topicPartition, long offset) { 
    delegate.seek(topicPartition, offset);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToBeginningAndForget(TopicPartition topicPartition) { 
    delegate.seekToBeginning(topicPartition);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set<TopicPartition>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set<TopicPartition>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set<TopicPartition>)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToBeginningAndForget(Set<TopicPartition> topicPartitions) { 
    delegate.seekToBeginning(topicPartitions);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToEndAndForget(TopicPartition topicPartition) { 
    delegate.seekToEnd(topicPartition);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set<TopicPartition>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set<TopicPartition>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set<TopicPartition>)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition for which seek
   * @return current KafkaConsumer instance
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToEndAndForget(Set<TopicPartition> topicPartitions) { 
    delegate.seekToEnd(topicPartitions);
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit} but you don't need to compose it with other operations.
   */
  public void commitAndForget() { 
    delegate.commit();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  private Multi<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> multi;
  public synchronized Multi<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> conv = io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
    return arg != null ? new KafkaConsumer<K,V>(arg) : null;
  }


  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
