package io.vertx.mutiny.kafka.client.producer;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.kafka.client.producer.RecordMetadata;
import io.vertx.kafka.client.common.PartitionInfo;
import java.util.List;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Vert.x Kafka producer.
 * <p>
 * The  provides global control over writing a record.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.producer.KafkaProducer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.producer.KafkaProducer.class)
public class KafkaProducer<K,V> implements io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaProducer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaProducer((io.vertx.kafka.client.producer.KafkaProducer) obj),
    KafkaProducer::getDelegate
  );

  private final io.vertx.kafka.client.producer.KafkaProducer<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaProducer(io.vertx.kafka.client.producer.KafkaProducer delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  KafkaProducer() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.producer.KafkaProducer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaProducer that = (KafkaProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord, io.vertx.kafka.client.producer.KafkaProducerRecord<K,V>> conv = io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V>::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private void __end(Handler<AsyncResult<Void>> arg0) { 
    delegate.end(arg0);
  }

  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  private void __end(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  public Uni<Void> end(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  public Void endAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param name the producer name to identify it
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> createShared(io.vertx.mutiny.core.Vertx vertx, String name, Map<String, String> config, Class<K> keyType, Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.createShared(vertx.getDelegate(), name, config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.mutiny.core.Vertx vertx, Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config), io.smallrye.mutiny.vertx.TypeArg.unknown(), io.smallrye.mutiny.vertx.TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka producer configuration
   * @param keyType class type for the key serialization
   * @param valueType class type for the value serialization
   * @return an instance of the KafkaProducer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> create(io.vertx.mutiny.core.Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> ret = io.vertx.mutiny.kafka.client.producer.KafkaProducer.newInstance(io.vertx.kafka.client.producer.KafkaProducer.create(vertx.getDelegate(), config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> setWriteQueueMaxSize(int i) { 
    delegate.setWriteQueueMaxSize(i);
    return this;
  }

  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __write(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Uni<Void> write(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  public Void writeAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    return (Void) write(data).await().indefinitely();
  }

  /**
   * @param record record to write
   * @param handler handler called on operation completed
   * @return current KafkaWriteStream instance
   */
  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record, Handler<AsyncResult<RecordMetadata>> handler) { 
    delegate.send(record.getDelegate(), handler);
    return this;
  }

  /**
   * Asynchronously write a record to a topic
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public Uni<RecordMetadata> send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(record, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K,V>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public RecordMetadata sendAndAwait(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    return (RecordMetadata) send(record).await().indefinitely();
  }

  /**
   * @param topic topic partition for which getting partitions info
   * @param handler handler called on operation completed
   * @return current KafkaProducer instance
   */
  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) { 
    delegate.partitionsFor(topic, handler);
    return this;
  }

  /**
   * Get the partition metadata for the give topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public Uni<List<PartitionInfo>> partitionsFor(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __partitionsFor(topic, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#partitionsFor(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic partition for which getting partitions info
   * @return current KafkaProducer instance
   */
  public List<PartitionInfo> partitionsForAndAwait(String topic) { 
    return (List<PartitionInfo>) partitionsFor(topic).await().indefinitely();
  }

  /**
   * @param completionHandler handler called on operation completed
   * @return current KafkaProducer instance
   */
  private io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> __flush(Handler<Void> completionHandler) { 
    delegate.flush(completionHandler);
    return this;
  }

  /**
   * @param completionHandler handler called on operation completed
   * @return current KafkaProducer instance
   */
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> flush(Consumer<Void> completionHandler) {
    return __flush(completionHandler != null ? completionHandler::accept : null);
  }

  /**
   * @param completionHandler handler called on operation completed
   */
  private void __close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Close the producer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * @param timeout timeout to wait for closing
   * @param completionHandler handler called on operation completed
   */
  private void __close(long timeout, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(timeout, completionHandler);
  }

  /**
   * Close the producer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout timeout to wait for closing
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout timeout to wait for closing
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait(long timeout) { 
    return (Void) close(timeout).await().indefinitely();
  }

  public void endAndForget() { 
    delegate.end();
  }

  public void endAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> data) { 
    delegate.end(data.getDelegate());
  }

  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> writeAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> kafkaProducerRecord) { 
    delegate.write(kafkaProducerRecord.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K,V>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K,V>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#send(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K,V>)} but you don't need to compose it with other operations.
   * @param record record to write
   * @return current KafkaWriteStream instance
   */
  public io.vertx.mutiny.kafka.client.producer.KafkaProducer<K, V> sendAndForget(io.vertx.mutiny.kafka.client.producer.KafkaProducerRecord<K, V> record) { 
    delegate.send(record.getDelegate());
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.producer.KafkaProducer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  public static <K,V>KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg) {
    return arg != null ? new KafkaProducer<K,V>(arg) : null;
  }


  public static <K,V>KafkaProducer<K,V> newInstance(io.vertx.kafka.client.producer.KafkaProducer arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaProducer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
