/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public class CompletableConverter
implements ReactiveTypeConverter<Completable> {
    public <T> CompletionStage<T> toCompletionStage(Completable instance) {
        CompletableFuture future = new CompletableFuture();
        Completable s = Objects.requireNonNull(instance);
        s.subscribe(() -> future.complete(null), future::completeExceptionally);
        return future;
    }

    public Completable fromCompletionStage(CompletionStage cs) {
        CompletionStage future = Objects.requireNonNull(cs);
        return Completable.create(emitter -> future.whenComplete((res, err) -> {
            if (!emitter.isDisposed()) {
                if (err != null) {
                    if (err instanceof CompletionException) {
                        emitter.onError(err.getCause());
                    } else {
                        emitter.onError(err);
                    }
                } else {
                    emitter.onComplete();
                }
            }
        }));
    }

    public <X> Publisher<X> toRSPublisher(Completable instance) {
        return instance.toFlowable();
    }

    public <X> Completable fromPublisher(Publisher<X> publisher) {
        return Flowable.fromPublisher(publisher).ignoreElements();
    }

    public Class<Completable> type() {
        return Completable.class;
    }

    public boolean emitItems() {
        return false;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

