/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.reactive.messaging.MergeableMetadata;
import io.smallrye.reactive.messaging.TargetedMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public interface Messages {
    @CheckReturnValue
    public static MessageChainBuilder chain(Message<?> message) {
        return new MessageChainBuilder(message);
    }

    public static <T> Message<T> merge(List<Message<?>> list, Function<List<?>, T> combinator) {
        T payload;
        if (list.isEmpty()) {
            return Message.of(combinator.apply(Collections.emptyList()));
        }
        try {
            payload = combinator.apply(list.stream().map(Message::getPayload).collect(Collectors.toList()));
        }
        catch (Exception e) {
            list.forEach(m -> m.nack(e));
            throw e;
        }
        Function<Metadata, CompletionStage<Void>> ack = metadata -> {
            ArrayList<CompletableFuture<Void>> acks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                acks.add(message.ack((Metadata)metadata).toCompletableFuture());
            }
            return CompletableFuture.allOf(acks.toArray(new CompletableFuture[0]));
        };
        BiFunction<Throwable, Metadata, CompletionStage<Void>> nack = (metadata, throwable) -> {
            ArrayList<CompletableFuture<Void>> nacks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                nacks.add(message.nack((Throwable)metadata, (Metadata)throwable).toCompletableFuture());
            }
            return CompletableFuture.allOf(nacks.toArray(new CompletableFuture[0]));
        };
        Metadata metadata2 = list.get(0).getMetadata();
        for (int i = 1; i < list.size(); ++i) {
            Metadata other = list.get(i).getMetadata();
            metadata2 = Messages.merge(metadata2, other);
        }
        return Message.of(payload).withAckWithMetadata(ack).withNackWithMetadata(nack).withMetadata(metadata2);
    }

    public static <T> Message<List<T>> merge(List<Message<T>> list) {
        if (list.isEmpty()) {
            return Message.of(Collections.emptyList());
        }
        List payload = list.stream().map(Message::getPayload).collect(Collectors.toList());
        Function<Metadata, CompletionStage<Void>> ack = metadata -> {
            ArrayList<CompletableFuture<Void>> acks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                acks.add(message.ack((Metadata)metadata).toCompletableFuture());
            }
            return CompletableFuture.allOf(acks.toArray(new CompletableFuture[0]));
        };
        BiFunction<Throwable, Metadata, CompletionStage<Void>> nack = (metadata, throwable) -> {
            ArrayList<CompletableFuture<Void>> nacks = new ArrayList<CompletableFuture<Void>>();
            for (Message message : list) {
                nacks.add(message.nack((Throwable)metadata, (Metadata)throwable).toCompletableFuture());
            }
            return CompletableFuture.allOf(nacks.toArray(new CompletableFuture[0]));
        };
        Metadata metadata2 = list.get(0).getMetadata();
        for (int i = 1; i < list.size(); ++i) {
            Metadata other = list.get(i).getMetadata();
            metadata2 = Messages.merge(metadata2, other);
        }
        return Message.of(payload).withAckWithMetadata(ack).withNackWithMetadata(nack).withMetadata(metadata2);
    }

    public static Metadata merge(Metadata first, Metadata second) {
        Metadata result = first;
        for (Object meta : second) {
            Class<?> clazz = meta.getClass();
            Optional<?> value = result.get(clazz);
            if (value.isEmpty()) {
                result = result.with(meta);
                continue;
            }
            if (!MergeableMetadata.class.isAssignableFrom(clazz)) continue;
            MergeableMetadata current = (MergeableMetadata)value.get();
            Object merged = current.merge(meta);
            if (merged != null) {
                result = result.with(merged);
                continue;
            }
            result = result.without(clazz);
        }
        return result;
    }

    public static class MessageChainBuilder {
        private final Message<?> input;
        private Metadata metadata;

        private MessageChainBuilder(Message<?> message) {
            this.input = message;
            this.metadata = message.getMetadata().copy();
        }

        @CheckReturnValue
        public MessageChainBuilder withoutMetadata() {
            this.metadata = Metadata.empty();
            return this;
        }

        @CheckReturnValue
        public MessageChainBuilder withMetadata(Class<?> ... mc) {
            for (Class<?> clazz : mc) {
                Optional<?> o = this.input.getMetadata().get(clazz);
                o.ifPresent(value -> {
                    this.metadata = this.metadata.with(value);
                });
            }
            return this;
        }

        @CheckReturnValue
        public MessageChainBuilder withoutMetadata(Class<?> ... mc) {
            for (Class<?> clazz : mc) {
                this.metadata = this.metadata.without(clazz);
            }
            return this;
        }

        public List<Message<?>> with(Message<?> ... messages) {
            AtomicBoolean done = new AtomicBoolean();
            List trackers = Arrays.stream(messages).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            ArrayList outcomes = new ArrayList();
            Message<?>[] messageArray = messages;
            int n = messageArray.length;
            for (int i = 0; i < n; ++i) {
                Message<?> message;
                Message<?> tmp = message = messageArray[i];
                for (Object metadatum : this.metadata) {
                    tmp = tmp.addMetadata(metadatum);
                }
                outcomes.add(tmp.withAckWithMetadata(metadata -> {
                    CompletionStage<Void> acked = message.ack((Metadata)metadata);
                    if (trackers.remove(message) && trackers.isEmpty() && done.compareAndSet(false, true)) {
                        return acked.thenCompose(x -> this.input.ack((Metadata)metadata));
                    }
                    return acked;
                }).withNackWithMetadata((reason, metadata) -> {
                    CompletionStage<Void> nacked = message.nack((Throwable)reason, (Metadata)metadata);
                    if (trackers.remove(message) && done.compareAndSet(false, true)) {
                        return nacked.thenCompose(x -> this.input.nack((Throwable)reason, (Metadata)metadata));
                    }
                    return nacked;
                }));
            }
            return outcomes;
        }

        public TargetedMessages with(Map<String, Message<?>> messages) {
            AtomicBoolean done = new AtomicBoolean();
            CopyOnWriteArrayList trackers = new CopyOnWriteArrayList(messages.values());
            HashMap outcomes = new HashMap();
            for (Map.Entry<String, Message<?>> entry : messages.entrySet()) {
                Message<?> message;
                String key = entry.getKey();
                Message<?> tmp = message = entry.getValue();
                for (Object metadatum : this.metadata) {
                    tmp = tmp.addMetadata(metadatum);
                }
                outcomes.put(key, tmp.withAckWithMetadata(metadata -> {
                    CompletionStage<Void> acked = message.ack((Metadata)metadata);
                    if (trackers.remove(message) && trackers.isEmpty() && done.compareAndSet(false, true)) {
                        return acked.thenCompose(x -> this.input.ack((Metadata)metadata));
                    }
                    return acked;
                }).withNackWithMetadata((reason, metadata) -> {
                    CompletionStage<Void> nacked = message.nack((Throwable)reason, (Metadata)metadata);
                    if (trackers.remove(message) && done.compareAndSet(false, true)) {
                        return nacked.thenCompose(x -> this.input.nack((Throwable)reason, (Metadata)metadata));
                    }
                    return nacked;
                }));
            }
            return TargetedMessages.from(outcomes);
        }
    }
}

