/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion;

import io.smallrye.reactive.messaging.kafka.companion.KafkaCompanion;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;

public class ClusterCompanion {
    private final AdminClient adminClient;
    private final Duration kafkaApiTimeout;

    public ClusterCompanion(AdminClient adminClient, Duration kafkaApiTimeout) {
        this.adminClient = adminClient;
        this.kafkaApiTimeout = kafkaApiTimeout;
    }

    public Collection<Node> nodes() {
        return (Collection)KafkaCompanion.toUni(() -> this.adminClient.describeCluster().nodes()).await().atMost(this.kafkaApiTimeout);
    }

    public Node controller() {
        return (Node)KafkaCompanion.toUni(() -> this.adminClient.describeCluster().controller()).await().atMost(this.kafkaApiTimeout);
    }

    public String clusterId() {
        return (String)KafkaCompanion.toUni(() -> this.adminClient.describeCluster().clusterId()).await().atMost(this.kafkaApiTimeout);
    }

    public Set<AclOperation> aclOperations() {
        return (Set)KafkaCompanion.toUni(() -> this.adminClient.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true)).authorizedOperations()).await().atMost(this.kafkaApiTimeout);
    }
}

