/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.companion.test;

import io.smallrye.reactive.messaging.kafka.companion.test.KafkaBrokerExtension;
import io.smallrye.reactive.messaging.kafka.companion.test.KafkaProxy;
import io.smallrye.reactive.messaging.kafka.companion.test.ProxiedStrimziKafkaContainer;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.testcontainers.containers.Network;
import org.testcontainers.shaded.org.awaitility.Awaitility;

public class KafkaToxiproxyExtension
extends KafkaBrokerExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver,
ExtensionContext.Store.CloseableResource {
    public static final Logger LOGGER = Logger.getLogger(KafkaToxiproxyExtension.class.getName());

    @Override
    public void beforeAll(ExtensionContext context) {
        ExtensionContext.Store globalStore = context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        KafkaToxiproxyExtension extension = (KafkaToxiproxyExtension)globalStore.get(KafkaToxiproxyExtension.class);
        if (extension == null) {
            LOGGER.info("Starting Kafka broker proxy");
            this.kafka = KafkaToxiproxyExtension.configureKafkaContainer(new ProxiedStrimziKafkaContainer());
            this.kafka.setNetwork(Network.newNetwork());
            this.kafka.start();
            Awaitility.await().until(() -> this.kafka.isRunning());
            globalStore.put(KafkaToxiproxyExtension.class, (Object)this);
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return super.supportsParameter(parameterContext, extensionContext) || parameterContext.getParameter().getType().equals(KafkaProxy.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ExtensionContext.Store globalStore = extensionContext.getRoot().getStore(ExtensionContext.Namespace.GLOBAL);
        KafkaToxiproxyExtension extension = (KafkaToxiproxyExtension)globalStore.get(KafkaToxiproxyExtension.class);
        if (extension != null && extension.kafka != null) {
            if (parameterContext.isAnnotated(KafkaBrokerExtension.KafkaBootstrapServers.class)) {
                return extension.kafka.getBootstrapServers();
            }
            if (parameterContext.getParameter().getType().equals(KafkaProxy.class)) {
                return ((ProxiedStrimziKafkaContainer)extension.kafka).getKafkaProxy();
            }
        }
        return null;
    }
}

