package io.smallrye.reactive.messaging.kafka.i18n;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class KafkaLogging_$logger extends DelegatingBasicLogger implements KafkaLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = KafkaLogging_$logger.class.getName();
    public KafkaLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void deadLetterConfig(final String deadQueueTopic, final String keySerializer, final String valueSerializer) {
        super.log.logf(FQCN, DEBUG, null, deadLetterConfig$str(), deadQueueTopic, keySerializer, valueSerializer);
    }
    protected String deadLetterConfig$str() {
        return "SRMSG18201: Dead queue letter configured with: topic: `%s`, key serializer: `%s`, value serializer: `%s`";
    }
    @Override
    public final void messageNackedDeadLetter(final String channel, final String topic) {
        super.log.logf(FQCN, INFO, null, messageNackedDeadLetter$str(), channel, topic);
    }
    protected String messageNackedDeadLetter$str() {
        return "SRMSG18202: A message sent to channel `%s` has been nacked, sending the record to a dead letter topic %s";
    }
    @Override
    public final void messageNackedFailStop(final String channel) {
        super.log.logf(FQCN, ERROR, null, messageNackedFailStop$str(), channel);
    }
    protected String messageNackedFailStop$str() {
        return "SRMSG18203: A message sent to channel `%s` has been nacked, fail-stop";
    }
    @Override
    public final void messageNackedIgnore(final String channel, final String reason) {
        super.log.logf(FQCN, WARN, null, messageNackedIgnore$str(), channel, reason);
    }
    protected String messageNackedIgnore$str() {
        return "SRMSG18204: A message sent to channel `%s` has been nacked, ignored failure is: %s.";
    }
    @Override
    public final void messageNackedFullIgnored(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, messageNackedFullIgnored$str());
    }
    protected String messageNackedFullIgnored$str() {
        return "SRMSG18205: The full ignored failure is";
    }
    @Override
    public final void unableToWrite(final String channel, final String topic, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToWrite2$str(), channel, topic);
    }
    protected String unableToWrite2$str() {
        return "SRMSG18206: Unable to write to Kafka from channel %s (topic: %s)";
    }
    @Override
    public final void unableToWrite(final String channel, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToWrite1$str(), channel);
    }
    protected String unableToWrite1$str() {
        return "SRMSG18206: Unable to write to Kafka from channel %s (no topic set)";
    }
    @Override
    public final void unableToDispatch(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToDispatch$str());
    }
    protected String unableToDispatch$str() {
        return "SRMSG18207: Unable to dispatch message to Kafka";
    }
    @Override
    public final void sendingMessageToTopic(final Message message, final String topic) {
        super.log.logf(FQCN, DEBUG, null, sendingMessageToTopic$str(), message, topic);
    }
    protected String sendingMessageToTopic$str() {
        return "SRMSG18209: Sending message %s to Kafka topic '%s'";
    }
    @Override
    public final void unableToSendRecord(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToSendRecord$str());
    }
    protected String unableToSendRecord$str() {
        return "SRMSG18210: Unable to send a record to Kafka ";
    }
    @Override
    public final void successfullyToTopic(final Message message, final String topic) {
        super.log.logf(FQCN, DEBUG, null, successfullyToTopic$str(), message, topic);
    }
    protected String successfullyToTopic$str() {
        return "SRMSG18211: Message %s sent successfully to Kafka topic '%s'";
    }
    @Override
    public final void nackingMessage(final Message message, final String topic, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, nackingMessage$str(), message, topic);
    }
    protected String nackingMessage$str() {
        return "SRMSG18212: Message %s was not sent to Kafka topic '%s' - nacking message";
    }
    @Override
    public final void configServers(final String serverConfig, final String servers) {
        super.log.logf(FQCN, INFO, null, configServers$str(), serverConfig, servers);
    }
    protected String configServers$str() {
        return "SRMSG18213: Setting %s to %s";
    }
    @Override
    public final void keyDeserializerOmitted() {
        super.log.logf(FQCN, INFO, null, keyDeserializerOmitted$str());
    }
    protected String keyDeserializerOmitted$str() {
        return "SRMSG18214: Key deserializer omitted, using String as default";
    }
    @Override
    public final void errorWhileClosingWriteStream(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, errorWhileClosingWriteStream$str());
    }
    protected String errorWhileClosingWriteStream$str() {
        return "SRMSG18215: An error has been caught while closing the Kafka Write Stream";
    }
    @Override
    public final void noGroupId(final String randomId) {
        super.log.logf(FQCN, WARN, null, noGroupId$str(), randomId);
    }
    protected String noGroupId$str() {
        return "SRMSG18216: No `group.id` set in the configuration, generate a random id: %s";
    }
    @Override
    public final void unableToReadRecord(final Set<String> topics, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToReadRecord$str(), topics);
    }
    protected String unableToReadRecord$str() {
        return "SRMSG18217: Unable to read a record from Kafka topics '%s'";
    }
    @Override
    public final void exceptionOnClose(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, exceptionOnClose$str());
    }
    protected String exceptionOnClose$str() {
        return "SRMSG18218: An exception has been caught while closing the Kafka consumer";
    }
    @Override
    public final void loadingConsumerRebalanceListenerFromConfiguredName(final String configuredName) {
        super.log.logf(FQCN, INFO, null, loadingConsumerRebalanceListenerFromConfiguredName$str(), configuredName);
    }
    protected String loadingConsumerRebalanceListenerFromConfiguredName$str() {
        return "SRMSG18219: Loading KafkaConsumerRebalanceListener from configured name '%s'";
    }
    @Override
    public final void loadingConsumerRebalanceListenerFromGroupId(final String consumerGroup) {
        super.log.logf(FQCN, INFO, null, loadingConsumerRebalanceListenerFromGroupId$str(), consumerGroup);
    }
    protected String loadingConsumerRebalanceListenerFromGroupId$str() {
        return "SRMSG18220: Loading KafkaConsumerRebalanceListener from group id '%s'";
    }
    @Override
    public final void unableToExecuteConsumerAssignedRebalanceListener(final String consumerGroup, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToExecuteConsumerAssignedRebalanceListener$str(), consumerGroup);
    }
    protected String unableToExecuteConsumerAssignedRebalanceListener$str() {
        return "SRMSG18221: Unable to execute consumer assigned re-balance listener for group '%s'. The consumer has been paused. Will retry until the consumer session times out in which case will resume to force a new re-balance attempt.";
    }
    @Override
    public final void unableToExecuteConsumerRevokedRebalanceListener(final String consumerGroup, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToExecuteConsumerRevokedRebalanceListener$str(), consumerGroup);
    }
    protected String unableToExecuteConsumerRevokedRebalanceListener$str() {
        return "SRMSG18222: Unable to execute consumer revoked re-balance listener for group '%s'";
    }
    @Override
    public final void executingConsumerAssignedRebalanceListener(final String consumerGroup) {
        super.log.logf(FQCN, INFO, null, executingConsumerAssignedRebalanceListener$str(), consumerGroup);
    }
    protected String executingConsumerAssignedRebalanceListener$str() {
        return "SRMSG18223: Executing consumer assigned re-balance listener for group '%s'";
    }
    @Override
    public final void executingConsumerRevokedRebalanceListener(final String consumerGroup) {
        super.log.logf(FQCN, INFO, null, executingConsumerRevokedRebalanceListener$str(), consumerGroup);
    }
    protected String executingConsumerRevokedRebalanceListener$str() {
        return "SRMSG18224: Executing consumer revoked re-balance listener for group '%s'";
    }
    @Override
    public final void executedConsumerAssignedRebalanceListener(final String consumerGroup) {
        super.log.logf(FQCN, INFO, null, executedConsumerAssignedRebalanceListener$str(), consumerGroup);
    }
    protected String executedConsumerAssignedRebalanceListener$str() {
        return "SRMSG18225: Executed consumer assigned re-balance listener for group '%s'";
    }
    @Override
    public final void executedConsumerRevokedRebalanceListener(final String consumerGroup) {
        super.log.logf(FQCN, INFO, null, executedConsumerRevokedRebalanceListener$str(), consumerGroup);
    }
    protected String executedConsumerRevokedRebalanceListener$str() {
        return "SRMSG18226: Executed consumer revoked re-balance listener for group '%s'";
    }
    @Override
    public final void reEnablingConsumerForGroup(final String consumerGroup) {
        super.log.logf(FQCN, WARN, null, reEnablingConsumerForGroup$str(), consumerGroup);
    }
    protected String reEnablingConsumerForGroup$str() {
        return "SRMSG18227: Re-enabling consumer for group '%s'. This consumer was paused because of a re-balance failure.";
    }
    @Override
    public final void failureReported(final Set<String> topics, final Throwable t) {
        super.log.logf(FQCN, WARN, t, failureReported$str(), topics);
    }
    protected String failureReported$str() {
        return "SRMSG18228: A failure has been reported for Kafka topics '%s'";
    }
    @Override
    public final void failureReportedDuringRebalance(final Set<String> topics, final Throwable t) {
        super.log.logf(FQCN, WARN, t, failureReportedDuringRebalance$str(), topics);
    }
    protected String failureReportedDuringRebalance$str() {
        return "SRMSG18242: A failure has been reported during a rebalance - the operation will be retried: '%s'";
    }
    @Override
    public final void configuredTopics(final String channel, final Set<String> topics) {
        super.log.logf(FQCN, INFO, null, configuredTopics$str(), channel, topics);
    }
    protected String configuredTopics$str() {
        return "SRMSG18229: Configured topics for channel '%s': %s";
    }
    @Override
    public final void configuredPattern(final String channel, final String pattern) {
        super.log.logf(FQCN, INFO, null, configuredPattern$str(), channel, pattern);
    }
    protected String configuredPattern$str() {
        return "SRMSG18230: Configured topics matching pattern for channel '%s': %s";
    }
    @Override
    public final void receivedTooManyMessagesWithoutAcking(final String topicPartition, final long amount, final long lastCommittedOffset) {
        super.log.logf(FQCN, WARN, null, receivedTooManyMessagesWithoutAcking$str(), topicPartition, amount, lastCommittedOffset);
    }
    protected String receivedTooManyMessagesWithoutAcking$str() {
        return "SRMSG18231: The amount of received messages without acking is too high for topic partition '%s', amount %d. The last committed offset was %d. It means that the Kafka connector received Kafka Records that have neither be acked nor nacked in a timely fashion. The connector accumulates records in memory, but that buffer reached its maximum capacity or the deadline for ack/nack expired. The connector cannot commit as a record processing has not completed.";
    }
    @Override
    public final void settingCommitInterval(final String group, final long commitInterval) {
        super.log.logf(FQCN, INFO, null, settingCommitInterval$str(), group, commitInterval);
    }
    protected String settingCommitInterval$str() {
        return "SRMSG18232: Will commit for group '%s' every %d milliseconds.";
    }
    @Override
    public final void invalidValueSerializerForStructuredCloudEvent(final String serializer) {
        super.log.logf(FQCN, ERROR, null, invalidValueSerializerForStructuredCloudEvent$str(), serializer);
    }
    protected String invalidValueSerializerForStructuredCloudEvent$str() {
        return "SRMSG18233: Invalid value serializer to write a structured Cloud Event. Found %d, expected the org.apache.kafka.common.serialization.StringSerializer";
    }
    @Override
    public final void disableAutoCommit(final String channel) {
        super.log.logf(FQCN, INFO, null, disableAutoCommit$str(), channel);
    }
    protected String disableAutoCommit$str() {
        return "SRMSG18234: Auto-commit disabled for channel %s";
    }
    @Override
    public final void disableThrottledCommitStrategyHealthCheck(final String group) {
        super.log.logf(FQCN, WARN, null, disableThrottledCommitStrategyHealthCheck$str(), group);
    }
    protected String disableThrottledCommitStrategyHealthCheck$str() {
        return "SRMSG18235: Will not health check throttled commit strategy for group '%s'.";
    }
    @Override
    public final void setThrottledCommitStrategyReceivedRecordMaxAge(final String group, final long unprocessedRecordMaxAge) {
        super.log.logf(FQCN, INFO, null, setThrottledCommitStrategyReceivedRecordMaxAge$str(), group, unprocessedRecordMaxAge);
    }
    protected String setThrottledCommitStrategyReceivedRecordMaxAge$str() {
        return "SRMSG18236: Will mark throttled commit strategy for group '%s' as unhealthy if records go more than %d milliseconds without being processed.";
    }
    @Override
    public final void setKafkaProducerClientId(final String name) {
        super.log.logf(FQCN, INFO, null, setKafkaProducerClientId$str(), name);
    }
    protected String setKafkaProducerClientId$str() {
        return "SRMSG18237: Setting client.id for Kafka producer to %s";
    }
    @Override
    public final void setKafkaConsumerClientId(final String name) {
        super.log.logf(FQCN, INFO, null, setKafkaConsumerClientId$str(), name);
    }
    protected String setKafkaConsumerClientId$str() {
        return "SRMSG18238: Setting client.id for Kafka consumer to %s";
    }
    @Override
    public final void messageAckedForRevokedTopicPartition(final long offset, final String groupId, final String topicPartition) {
        super.log.logf(FQCN, WARN, null, messageAckedForRevokedTopicPartition$str(), offset, groupId, topicPartition);
    }
    protected String messageAckedForRevokedTopicPartition$str() {
        return "SRMSG18239: Acked record %d on group '%s' was ignored because the topic partition '%s' was revoked for this instance. Record will likely be processed again.";
    }
    @Override
    public final void commitStrategyForChannel(final String strategy, final String channel) {
        super.log.logf(FQCN, INFO, null, commitStrategyForChannel$str(), strategy, channel);
    }
    protected String commitStrategyForChannel$str() {
        return "SRMSG18240: '%s' commit strategy used for channel '%s'";
    }
    @Override
    public final void deserializationFailureHandlerFailure(final String instance, final Throwable t) {
        super.log.logf(FQCN, FATAL, t, deserializationFailureHandlerFailure$str(), instance);
    }
    protected String deserializationFailureHandlerFailure$str() {
        return "SRMSG18241: The deserialization failure handler `%s` throws an exception";
    }
    @Override
    public final void pauseAllPartitionOnTermination() {
        super.log.logf(FQCN, DEBUG, null, pauseAllPartitionOnTermination$str());
    }
    protected String pauseAllPartitionOnTermination$str() {
        return "SRMSG18243: Shutting down - Pausing all topic/partitions";
    }
    @Override
    public final void waitingForMessageProcessing(final long p) {
        super.log.logf(FQCN, DEBUG, null, waitingForMessageProcessing$str(), p);
    }
    protected String waitingForMessageProcessing$str() {
        return "SRMSG18244: Shutting down - Waiting for message processing to complete, %d messages still in processing";
    }
    @Override
    public final void messageStillUnprocessedAfterTimeout(final long unprocessed) {
        super.log.logf(FQCN, WARN, null, messageStillUnprocessedAfterTimeout$str(), unprocessed);
    }
    protected String messageStillUnprocessedAfterTimeout$str() {
        return "SRMSG18245: There are still %d unprocessed messages after the closing timeout";
    }
    @Override
    public final void pausingChannel(final String channel, final int queueSize, final int maxQueueSize) {
        super.log.logf(FQCN, DEBUG, null, pausingChannel$str(), channel, queueSize, maxQueueSize);
    }
    protected String pausingChannel$str() {
        return "SRMSG18246: Pausing Kafka consumption for channel %s, queue size %s is more than %s";
    }
    @Override
    public final void resumingChannel(final String channel, final int queueSize, final int halfMaxQueueSize) {
        super.log.logf(FQCN, DEBUG, null, resumingChannel$str(), channel, queueSize, halfMaxQueueSize);
    }
    protected String resumingChannel$str() {
        return "SRMSG18247: Resuming Kafka consumption for channel %s, queue size %s is less than %s";
    }
    @Override
    public final void keySerializerOmitted() {
        super.log.logf(FQCN, INFO, null, keySerializerOmitted$str());
    }
    protected String keySerializerOmitted$str() {
        return "SRMSG18248: Key serializer omitted, using String as default";
    }
    @Override
    public final void unableToDeserializeMessage(final String topic, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToDeserializeMessage$str(), topic);
    }
    protected String unableToDeserializeMessage$str() {
        return "SRMSG18249: Unable to recover from the deserialization failure (topic: %s), configure a DeserializationFailureHandler to recover from errors.";
    }
    @Override
    public final void deprecatedConfig(final String deprecated, final String replace) {
        super.log.logf(FQCN, WARN, null, deprecatedConfig$str(), deprecated, replace);
    }
    protected String deprecatedConfig$str() {
        return "SRMSG18250: The configuration property '%s' is deprecated and is replaced by '%s'.";
    }
}
