/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConnectorConfig
implements Config {
    private final String prefix;
    private final Config overall;
    private final String name;
    private final String connector;

    protected ConnectorConfig(String prefix, Config overall, String channel) {
        this.prefix = Objects.requireNonNull(prefix, "the prefix must not be set");
        this.overall = Objects.requireNonNull(overall, "the config must not be set");
        this.name = Objects.requireNonNull(channel, "the channel name must be set");
        Optional value = overall.getOptionalValue(this.channelKey("connector"), String.class);
        this.connector = value.orElseGet(() -> (String)overall.getOptionalValue(this.channelKey("type"), String.class).orElseThrow(() -> new IllegalArgumentException("Invalid channel configuration - the `connector` attribute must be set for channel `" + this.name + "`")));
        for (String key : overall.getPropertyNames()) {
            if (!this.channelKey("channel-name").equalsIgnoreCase(key)) continue;
            throw new IllegalArgumentException("Invalid channel configuration -  the `channel-name` attribute cannot be used in configuration (channel `" + this.name + "`)");
        }
    }

    private String channelKey(String keyName) {
        return this.prefix + this.name + "." + keyName;
    }

    private String connectorKey(String keyName) {
        return "mp.messaging.connector." + this.connector + "." + keyName;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return (T)this.name;
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return (T)this.connector;
        }
        try {
            return (T)this.overall.getValue(this.channelKey(propertyName), propertyType);
        }
        catch (NoSuchElementException e) {
            try {
                return (T)this.overall.getValue(this.connectorKey(propertyName), propertyType);
            }
            catch (NoSuchElementException e2) {
                throw new NoSuchElementException("Cannot find attribute `" + propertyName + "` for channel `" + this.name + "`. Has been tried: " + this.channelKey(propertyName) + " and " + this.connectorKey(propertyName));
            }
        }
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return Optional.of(this.name);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return Optional.of(this.connector);
        }
        Optional maybe = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        return maybe.isPresent() ? maybe : this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
    }

    public Iterable<String> getPropertyNames() {
        Set<String> strings = StreamSupport.stream(this.overall.getPropertyNames().spliterator(), false).filter(s -> s.startsWith("mp.messaging.connector." + this.connector + ".")).map(s -> s.substring(("mp.messaging.connector." + this.connector + ".").length())).collect(Collectors.toSet());
        StreamSupport.stream(this.overall.getPropertyNames().spliterator(), false).filter(s -> s.startsWith(this.prefix + this.name + ".")).map(s -> s.substring((this.prefix + this.name + ".").length())).forEach(strings::add);
        strings.add("channel-name");
        return strings;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.overall.getConfigSources();
    }
}

