/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.wiring;

import io.smallrye.reactive.messaging.wiring.Wiring;
import io.smallrye.reactive.messaging.wiring.WiringException;
import java.util.List;

public class TooManyUpstreamCandidatesException
extends WiringException {
    private final Wiring.ConsumingComponent component;
    private final String incoming;
    private final List<Wiring.Component> upstreams;

    public TooManyUpstreamCandidatesException(Wiring.ConsumingComponent cc) {
        this(cc, null, null);
    }

    public TooManyUpstreamCandidatesException(Wiring.ConsumingComponent cc, String incoming, List<Wiring.Component> upstreams) {
        this.component = cc;
        this.incoming = incoming;
        this.upstreams = upstreams;
    }

    public String getMessage() {
        if (this.incoming != null && this.upstreams != null) {
            return String.format("'%s' supports a single upstream producer for channel '%s', but found %d: %s. You may want to add the '@Merge' annotation on the method.", this.component, this.incoming, this.upstreams.size(), this.upstreams);
        }
        if (this.component instanceof Wiring.ProcessorMediatorComponent || this.component instanceof Wiring.SubscriberMediatorComponent) {
            return String.format("'%s' supports a single upstream producer, but found %d: %s. You may want to add the '@Merge' annotation on the method.", this.component, this.component.upstreams().size(), this.component.upstreams());
        }
        return String.format("'%s' supports a single upstream producer, but found %d: %s.", this.component, this.component.upstreams().size(), this.component.upstreams());
    }
}

