/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.ExecutorFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultExecutorFactory
implements ExecutorFactory {
    private static final int KEEP_ALIVE_TIME = 600;

    @Override
    public ExecutorService createCoreExecutor(int size) {
        return new ThreadPoolExecutor(1, size, 600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    public ExecutorService createExecutor(int coreSize, int size) {
        return new ThreadPoolExecutor(coreSize, size, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public ScheduledExecutorService createTimeoutExecutor(int size) {
        return Executors.newScheduledThreadPool(size);
    }

    @Override
    public int priority() {
        return 0;
    }
}

