/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.metrics.MPMetricsService;
import io.smallrye.graphql.cdi.metrics.MicrometerMetricsService;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import javax.annotation.Priority;

@Priority(value=100)
public class MetricsService
implements EventingService {
    private final EventingService wrapped;

    public MetricsService() {
        Object wrappedImpl;
        try {
            Class.forName("io.micrometer.core.instrument.MeterRegistry");
            wrappedImpl = new MicrometerMetricsService();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.eclipse.microprofile.metrics.MetricRegistry");
                wrappedImpl = new MPMetricsService();
            }
            catch (ClassNotFoundException classNotFoundException) {
                wrappedImpl = null;
            }
        }
        this.wrapped = wrappedImpl;
    }

    public Operation createOperation(Operation operation) {
        return this.wrapped.createOperation(operation);
    }

    public void beforeDataFetch(Context context) {
        this.wrapped.beforeDataFetch(context);
    }

    public void afterDataFetch(Context context) {
        this.wrapped.afterDataFetch(context);
    }

    public String getConfigKey() {
        return "smallrye.graphql.metrics.enabled";
    }
}

