/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.command;

import io.snyk.snyk_maven_plugin.command.Command;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface CommandLine {
    public static final String INTEGRATION_NAME = "MAVEN_PLUGIN";

    public Process start() throws IOException;

    public static ProcessBuilder asProcessBuilder(String cliExecutablePath, Command command, Optional<String> apiToken, List<String> args, boolean color) {
        Stream<String> baseParts = Stream.of(cliExecutablePath, command.commandName(), "--integration-name=MAVEN_PLUGIN");
        Stream<String> normalisedArgs = args.stream().map(String::trim).filter(arg -> !arg.startsWith("--integration-name"));
        List<String> parts = Stream.concat(baseParts, normalisedArgs).collect(Collectors.toList());
        ProcessBuilder pb = new ProcessBuilder(parts);
        if (color) {
            pb.environment().put("FORCE_COLOR", "true");
        }
        apiToken.ifPresent(t -> pb.environment().put("SNYK_TOKEN", (String)t));
        return pb;
    }
}

