/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.download;

import java.nio.file.Paths;
import java.util.Locale;

public enum Platform {
    LINUX("snyk-linux"),
    LINUX_ALPINE("snyk-alpine"),
    MAC_OS("snyk-macos"),
    WINDOWS("snyk-win.exe");

    public final String snykExecutableFileName;

    private Platform(String snykExecutableFileName) {
        this.snykExecutableFileName = snykExecutableFileName;
    }

    public static Platform current() {
        return Platform.detect(System.getProperty("os.name"));
    }

    protected static Platform detect(String osName) {
        String osNameLower = osName.toLowerCase(Locale.ENGLISH);
        if (osNameLower.contains("linux")) {
            return Paths.get("/etc/alpine-release", new String[0]).toFile().exists() ? LINUX_ALPINE : LINUX;
        }
        if (osNameLower.contains("mac os x") || osNameLower.contains("darwin") || osNameLower.contains("osx")) {
            return MAC_OS;
        }
        if (osNameLower.contains("windows")) {
            return WINDOWS;
        }
        throw new IllegalArgumentException(osNameLower + " is not supported.");
    }
}

