/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import java.util.Calendar;
import java.util.TimeZone;

public class Transformers {
    private static TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static Long asLong(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (long)((Long)obj);
        }
        return null;
    }

    public static Long asDate(Object obj) {
        Calendar c = Transformers.toCalendar(obj);
        if (c == null) {
            return null;
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static Long asDateHourMinute(Object obj) {
        Calendar c = Transformers.toCalendar(obj);
        if (c == null) {
            return null;
        }
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    private static Calendar toCalendar(Object obj) {
        Long millisecondsSinceEpoch = Transformers.asLong(obj);
        if (millisecondsSinceEpoch == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(UTC);
        c.setTimeInMillis(millisecondsSinceEpoch);
        return c;
    }
}

