/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class ModelPropertyBuilder {
    private ResolvedType type;
    private String qualifiedType;
    private int position;
    private Boolean required;
    private Boolean readOnly;
    private String description;
    private AllowableValues allowableValues;
    private String name;
    private boolean isHidden;
    private String example;

    public ModelPropertyBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ModelPropertyBuilder type(ResolvedType type) {
        this.type = BuilderDefaults.replaceIfMoreSpecific(type, this.type);
        return this;
    }

    public ModelPropertyBuilder qualifiedType(String qualifiedType) {
        this.qualifiedType = BuilderDefaults.defaultIfAbsent(qualifiedType, this.qualifiedType);
        return this;
    }

    public ModelPropertyBuilder position(int position) {
        this.position = position;
        return this;
    }

    public ModelPropertyBuilder required(Boolean required) {
        this.required = required;
        return this;
    }

    public ModelPropertyBuilder readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ModelPropertyBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ModelPropertyBuilder example(String example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelPropertyBuilder allowableValues(AllowableValues allowableValues) {
        if (allowableValues != null) {
            this.allowableValues = allowableValues instanceof AllowableListValues ? BuilderDefaults.defaultIfAbsent(Enums.emptyListValuesToNull((AllowableListValues)allowableValues), this.allowableValues) : BuilderDefaults.defaultIfAbsent(allowableValues, this.allowableValues);
        }
        return this;
    }

    public ModelPropertyBuilder isHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public ModelProperty build() {
        return new ModelProperty(this.name, this.type, this.qualifiedType, this.position, this.required, this.isHidden, this.readOnly, this.description, this.allowableValues, this.example);
    }
}

