/*
 * Decompiled with CFR 0.152.
 */
package springfox.petstore.model;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import springfox.petstore.model.Pet;
import springfox.petstore.model.Tag;

public class Pets {
    public static Predicate<Pet> statusIs(final String status) {
        return new Predicate<Pet>(){

            public boolean apply(Pet input) {
                return Objects.equal((Object)input.getStatus(), (Object)status);
            }
        };
    }

    public static Predicate<Pet> tagsContain(final String tag) {
        return new Predicate<Pet>(){

            public boolean apply(Pet input) {
                return Iterables.any(input.getTags(), (Predicate)Pets.withName(tag));
            }
        };
    }

    private static Predicate<Tag> withName(final String tag) {
        return new Predicate<Tag>(){

            public boolean apply(Tag input) {
                return Objects.equal((Object)input.getName(), (Object)tag);
            }
        };
    }
}

