/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spring.web.Paths;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
public class ClassOrApiAnnotationResourceGrouping
implements ResourceGroupingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClassOrApiAnnotationResourceGrouping.class);

    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String group = Paths.splitCamelCase((String)controllerClass.getSimpleName(), (String)" ");
        return (String)this.extractAnnotation(controllerClass, this.descriptionOrValueExtractor()).or((Object)group);
    }

    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class);
        if (null != apiAnnotation && StringUtils.hasText((String)apiAnnotation.value())) {
            return apiAnnotation.position();
        }
        return 0;
    }

    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        String group = this.getClassOrApiAnnotationValue(handlerMethod).toLowerCase().replaceAll(" ", "-").replaceAll("/", "");
        LOG.info("Group for method {} was {}", (Object)handlerMethod.getMethod().getName(), (Object)group);
        Integer position = this.getResourcePosition(requestMappingInfo, handlerMethod);
        return Sets.newHashSet((Object[])new ResourceGroup[]{new ResourceGroup(group.toLowerCase(), handlerMethod.getBeanType(), position)});
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private String getClassOrApiAnnotationValue(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String group = Paths.splitCamelCase((String)controllerClass.getSimpleName(), (String)" ");
        return (String)this.extractAnnotation(controllerClass, this.valueExtractor()).or((Object)group);
    }

    private Optional<String> extractAnnotation(Class<?> controllerClass, Function<Api, Optional<String>> annotationExtractor) {
        Api apiAnnotation = (Api)AnnotationUtils.findAnnotation(controllerClass, Api.class);
        return (Optional)annotationExtractor.apply((Object)apiAnnotation);
    }

    private Function<Api, Optional<String>> descriptionOrValueExtractor() {
        return new Function<Api, Optional<String>>(){

            public Optional<String> apply(Api input) {
                return ((Optional)ClassOrApiAnnotationResourceGrouping.this.descriptionExtractor().apply((Object)input)).or((Optional)ClassOrApiAnnotationResourceGrouping.this.valueExtractor().apply((Object)input));
            }
        };
    }

    private Function<Api, Optional<String>> valueExtractor() {
        return new Function<Api, Optional<String>>(){

            public Optional<String> apply(Api input) {
                if (null != input) {
                    String stripSlashes = input.value().replace("/", "");
                    return Optional.fromNullable((Object)Strings.emptyToNull((String)stripSlashes));
                }
                return Optional.absent();
            }
        };
    }

    private Function<Api, Optional<String>> descriptionExtractor() {
        return new Function<Api, Optional<String>>(){

            public Optional<String> apply(Api input) {
                if (null != input) {
                    return Optional.fromNullable((Object)Strings.emptyToNull((String)input.description()));
                }
                return Optional.absent();
            }
        };
    }
}

