/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.HttpException;
import io.strimzi.kafka.oauth.common.HttpTask;
import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    static final int DEFAULT_CONNECT_TIMEOUT = ConfigUtil.getConnectTimeout(new Config());
    static final int DEFAULT_READ_TIMEOUT = ConfigUtil.getReadTimeout(new Config());

    public static <T> T doWithRetries(int retries, long retryPauseMillis, MetricsHandler metricsHandler, HttpTask<T> task) throws ExecutionException {
        if (retries < 0) {
            throw new IllegalArgumentException("retries can't be negative");
        }
        retryPauseMillis = retryPauseMillis < 0L ? 0L : retryPauseMillis;
        int i = 0;
        while (true) {
            if (++i > 1 && retryPauseMillis > 0L) {
                log.debug("Pausing before retrying failed action (for {}ms)", (Object)retryPauseMillis);
                try {
                    Thread.sleep(retryPauseMillis);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException("Interrupted while pausing", e);
                }
            }
            try {
                if (i > 1) {
                    log.debug("Request attempt no. " + i);
                }
                long requestStartTime = System.currentTimeMillis();
                try {
                    T result = task.run();
                    if (metricsHandler != null) {
                        metricsHandler.addSuccessRequestTime(System.currentTimeMillis() - requestStartTime);
                    }
                    return result;
                }
                catch (Throwable t) {
                    if (metricsHandler != null) {
                        metricsHandler.addErrorRequestTime(t, System.currentTimeMillis() - requestStartTime);
                    }
                    throw t;
                }
            }
            catch (Exception e) {
                Exception exception = e;
                log.info("Action failed on try no. " + i, (Throwable)e);
                if (i <= retries) continue;
                String msg = "Action failed after " + i + " tries";
                log.debug(msg);
                throw new ExecutionException(msg, exception);
            }
            break;
        }
    }

    public static <T> T get(URI uri, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, null, null, authorization, null, null, responseType);
    }

    public static <T> T get(URI uri, SSLSocketFactory socketFactory, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, null, authorization, null, null, responseType);
    }

    public static <T> T get(URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, hostnameVerifier, authorization, null, null, responseType);
    }

    public static <T> T get(URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, Class<T> responseType, int connectTimeout, int readTimeout) throws IOException {
        return HttpUtil.request(uri, "GET", socketFactory, hostnameVerifier, authorization, null, null, responseType, connectTimeout, readTimeout);
    }

    public static <T> T post(URI uri, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, null, null, authorization, contentType, body, responseType);
    }

    public static <T> T post(URI uri, SSLSocketFactory socketFactory, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, null, authorization, contentType, body, responseType);
    }

    public static <T> T post(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, socketFactory, verifier, authorization, contentType, body, responseType);
    }

    public static <T> T post(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body, Class<T> responseType, int connectTimeout, int readTimeout) throws IOException {
        return HttpUtil.request(uri, "POST", socketFactory, verifier, authorization, contentType, body, responseType, connectTimeout, readTimeout);
    }

    public static void put(URI uri, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, null, null, authorization, contentType, body, null);
    }

    public static void put(URI uri, SSLSocketFactory socketFactory, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, socketFactory, null, authorization, contentType, body, null);
    }

    public static void put(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body) throws IOException {
        HttpUtil.request(uri, socketFactory, verifier, authorization, contentType, body, null);
    }

    public static void put(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, String contentType, String body, int connectTimeout, int readTimeout) throws IOException {
        HttpUtil.request(uri, "PUT", socketFactory, verifier, authorization, contentType, body, null, connectTimeout, readTimeout);
    }

    public static void delete(URI uri, String authorization) throws IOException {
        HttpUtil.request(uri, "DELETE", null, null, authorization, null, null, null, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static void delete(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization) throws IOException {
        HttpUtil.request(uri, "DELETE", socketFactory, verifier, authorization, null, null, null, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static void delete(URI uri, SSLSocketFactory socketFactory, HostnameVerifier verifier, String authorization, int connectTimeout, int readTimeout) throws IOException {
        HttpUtil.request(uri, "DELETE", socketFactory, verifier, authorization, null, null, null, connectTimeout, readTimeout);
    }

    public static <T> T request(URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, null, socketFactory, hostnameVerifier, authorization, contentType, body, responseType, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static <T> T request(URI uri, String method, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String contentType, String body, Class<T> responseType) throws IOException {
        return HttpUtil.request(uri, method, socketFactory, hostnameVerifier, authorization, contentType, body, responseType, DEFAULT_CONNECT_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public static <T> T request(URI uri, String method, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier, String authorization, String contentType, String body, Class<T> responseType, int connectTimeout, int readTimeout) throws IOException {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)uri.toURL().openConnection();
        }
        catch (IOException e) {
            throw new IOException("Failed to initialise connection to: " + uri, e);
        }
        HttpUtil.configureTimeouts(con, connectTimeout, readTimeout);
        HttpUtil.configureTLS(con, uri, socketFactory, hostnameVerifier);
        con.setUseCaches(false);
        if (body != null) {
            con.setDoOutput(true);
        }
        if (method == null) {
            method = body == null ? "GET" : (responseType != null ? "POST" : "PUT");
        }
        con.setRequestMethod(method);
        if (authorization != null) {
            con.setRequestProperty("Authorization", authorization);
        }
        con.setRequestProperty("Accept", "application/json");
        if (body != null && body.length() > 0) {
            if (contentType == null) {
                throw new IllegalArgumentException("contentType must be set when body is not null");
            }
            con.setRequestProperty("Content-Type", contentType);
        }
        try {
            con.connect();
        }
        catch (ConnectException e) {
            throw new IOException("Failed to connect to: " + uri, e);
        }
        if (body != null && body.length() > 0) {
            try (OutputStream out = con.getOutputStream();){
                out.write(body.getBytes(StandardCharsets.UTF_8));
            }
        }
        return HttpUtil.handleResponse(con, method, uri, responseType);
    }

    private static void configureTLS(HttpURLConnection con, URI uri, SSLSocketFactory socketFactory, HostnameVerifier hostnameVerifier) {
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection scon = (HttpsURLConnection)con;
            if (socketFactory != null) {
                scon.setSSLSocketFactory(socketFactory);
            }
            if (hostnameVerifier != null) {
                scon.setHostnameVerifier(hostnameVerifier);
            }
        } else if (socketFactory != null) {
            log.warn("SSL socket factory set but url scheme not https ({})", (Object)uri);
        }
    }

    private static void configureTimeouts(HttpURLConnection con, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("connectTimeout <= 0");
        }
        con.setConnectTimeout(connectTimeout * 1000);
        if (readTimeout <= 0) {
            throw new IllegalArgumentException("readTimeout <= 0");
        }
        con.setReadTimeout(readTimeout * 1000);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static <T> T handleResponse(HttpURLConnection con, String method, URI uri, Class<T> responseType) throws IOException {
        int code = con.getResponseCode();
        if (code != 200 && code != 201 && code != 204) {
            InputStream err = con.getErrorStream();
            if (err != null) {
                ByteArrayOutputStream errbuf = new ByteArrayOutputStream(4096);
                try {
                    IOUtil.copy(err, errbuf);
                }
                catch (Exception e) {
                    log.warn("[IGNORED] Failed to read response body", (Throwable)e);
                }
                throw new HttpException(method, uri, code, errbuf.toString(StandardCharsets.UTF_8.name()));
            }
            throw new HttpException(method, uri, code, con.getResponseMessage());
        }
        try (InputStream response = con.getInputStream();){
            if (responseType == null) {
                response.close();
                T e = null;
                return e;
            }
            InputStream is = response;
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtil.copy(response, buffer);
                log.trace("Response body for " + method + " " + uri + ": " + buffer.toString("utf-8"));
                is = new ByteArrayInputStream(buffer.toByteArray());
            }
            T t = JSONUtil.readJSON(is, responseType);
            return t;
        }
    }
}

